/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.action;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParser;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.mdl.link.design.MacrosMicroPatternsAndDEUsagesParser;
import com.ibm.pdp.mdl.link.design.MicroPatternsAndDEUsagesResults;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.pac.explorer.action.PacSearchDetailsTool;
import com.ibm.pdp.pac.explorer.model.PacSearchInDetail;
import com.ibm.pdp.pac.explorer.model.PacSearchInFile;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.pattern.PacServerSearchInPattern;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class PacServerSearchDetailsTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacServerSearchDetailsTool.class.getName()) + "_ID";

    public static List<Reference> getDetailedUsages(PacServerSearchInResult searchResult, PacServerSearchInFile file, IProgressMonitor monitor) {
        String streamID = file.getProject().getStreamID();
        String componentID = file.getProject().getComponentID();
        PacServerSearchInPattern searchPattern = searchResult.getSearchPattern();
        Document metaTarget = searchPattern.getDocument();
        byte[] fileContents = null;
        try {
            fileContents = PTRepositoryManager.retrieveFileContents((String)streamID, (String)componentID, (IPath)file.getFilePath(), (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException e) {
            PTMessageManager.logError((Throwable)e);
            return Collections.emptyList();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContents);
        List allDetailedUsages = new ArrayList();
        if (PTModelManager.accept((String)file.getDocument().getType())) {
            RadicalEntity radicalObject = PTResourceManager.loadResource((InputStream)inputStream, null);
            if (radicalObject instanceof PacMacro) {
                ByteArrayInputStream sourceStream = new ByteArrayInputStream(((PacMacro)radicalObject).getSource().getBytes());
                MacrosMicroPatternsAndDEUsagesParser parser = new MacrosMicroPatternsAndDEUsagesParser();
                MicroPatternsAndDEUsagesResults parserResult = parser.parse(file.getFilePath().toString(), (InputStream)sourceStream);
                allDetailedUsages = parserResult.getDetailedUsages();
            }
        } else {
            PdpFileGenerationLinksParser parser = new PdpFileGenerationLinksParser();
            PdpFileGenerationLinksParserResult parserResult = parser.parse((InputStream)inputStream, null, true);
            allDetailedUsages = parserResult.getDetailedUsages();
        }
        ArrayList<Reference> detailedUsages = new ArrayList<Reference>();
        for (Reference detailedReference : allDetailedUsages) {
            String[] tokens = MetadataService.getTokens((String)detailedReference.getTargetId());
            if (!metaTarget.getName().equals(tokens[2]) || !metaTarget.getMetaType().equals(tokens[3]) || !metaTarget.getType().equals(tokens[4])) continue;
            detailedUsages.add(detailedReference);
        }
        return detailedUsages;
    }

    public static PacSearchInDetail createDetail(PacServerSearchInFile file, Reference metaReference) {
        return PacSearchDetailsTool.createDetail((PacSearchInFile)file, (Reference)metaReference);
    }
}

