/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.action;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelLabel;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.pac.explorer.model.PacSearchInFile;
import com.ibm.pdp.pac.explorer.view.PacViewLabel;
import com.ibm.pdp.pac.server.action.PacServerSearchDetailsTool;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PacServerSearchDetailsTask {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacServerSearchDetailsTask.class.getName()) + "_ID";
    private TreeViewer _trvViewer;
    private PacServerSearchInResult _searchResult;
    private PacServerSearchInFile _file;

    public PacServerSearchDetailsTask(TreeViewer trvViewer, PacServerSearchInResult searchResult, PacServerSearchInFile file) {
        this._trvViewer = trvViewer;
        this._searchResult = searchResult;
        this._file = file;
    }

    public void syncExec() {
        Shell shell = this._trvViewer.getControl().getShell();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (PacServerSearchDetailsTask.this._file != null) {
                    String name = PacServerSearchDetailsTask.this._searchResult.getSearchPattern().getDocument().getName();
                    Object[] array = new String[]{name, PacServerSearchDetailsTask.this._file.getName()};
                    monitor.beginTask(PacViewLabel.getString((String)PacViewLabel._SEARCH_IN_DETAILS_JOB, (Object[])array), -1);
                    if (!PacServerSearchDetailsTask.this._file.isParsed()) {
                        PacServerSearchDetailsTask.this.buildDetails(PacServerSearchDetailsTask.this._file, monitor);
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            progressDialog.run(true, false, operation);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                PTMessageManager.handleStackTrace((Throwable)e.getCause());
            } else {
                PTMessageManager.handleStackTrace((Throwable)e);
            }
        }
        catch (InterruptedException e) {
            if (e.getCause() != null) {
                PTMessageManager.handleStackTrace((Throwable)e.getCause());
            }
            PTMessageManager.handleStackTrace((Throwable)e);
        }
    }

    public void asyncExec(final IJobChangeListener listener) {
        Job searchJob = new Job(PacViewLabel.getString((String)PacViewLabel._SEARCH_IN_DETAILS_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                this.addJobChangeListener(listener);
                List files = PacServerSearchDetailsTask.this._searchResult.getFiles();
                int nbFiles = 0;
                int totalWork = files.size();
                monitor.beginTask(PacViewLabel.getString((String)PacViewLabel._SEARCH_IN_DETAILS_TITLE), totalWork);
                String name = PacServerSearchDetailsTask.this._searchResult.getSearchPattern().getDocument().getName();
                for (final PacSearchInFile file : files) {
                    Object[] array = new String[]{name, file.getName()};
                    monitor.setTaskName(PacViewLabel.getString((String)PacViewLabel._SEARCH_IN_DETAILS_JOB, (Object[])array));
                    if (!file.isParsed() && file instanceof PacServerSearchInFile) {
                        PacServerSearchDetailsTask.this.buildDetails((PacServerSearchInFile)file, monitor);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (PacServerSearchDetailsTask.this._trvViewer != null) {
                                    PacServerSearchDetailsTask.this._trvViewer.expandToLevel((Object)file, 1);
                                }
                            }
                        });
                    }
                    array = new String[]{Integer.toString(++nbFiles), Integer.toString(totalWork)};
                    monitor.subTask(PTModelLabel.getString((String)PTModelLabel._SUB_TASK, (Object[])array));
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
                monitor.done();
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        searchJob.setPriority(10);
        searchJob.setUser(true);
        searchJob.schedule();
    }

    private void buildDetails(PacServerSearchInFile file, IProgressMonitor monitor) {
        List<Reference> detailedUsages = PacServerSearchDetailsTool.getDetailedUsages(this._searchResult, file, monitor);
        file.setParsed(true);
        for (Reference detailedUsage : detailedUsages) {
            PacServerSearchDetailsTool.createDetail(file, detailedUsage);
        }
    }
}

