<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="TitleLine.xsl"></xsl:import>
	<xsl:import href="CallLine.xsl"></xsl:import>
	<xsl:import href="RequestLine.xsl"></xsl:import>
	<xsl:import href="All_form.xsl"></xsl:import>

	<xsl:param name="output.title"></xsl:param>
	<xsl:param name="output.css"></xsl:param>

	<!-- Publishing template -->
	<xsl:template match="rpp:publishing">
		<html>
			<head>
				<title>
					<xsl:value-of select="$output.title" />
				</title>
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"></meta>
				<xsl:choose>
					<xsl:when test="$output.css != ''">
						<link rel="stylesheet" href="{$output.css}" type="text/css"></link>
					</xsl:when>
					<xsl:otherwise>
						<link rel="stylesheet" href="rpp.css" type="text/css"></link>
					</xsl:otherwise>
				</xsl:choose>
			</head>
			<body>
				<xsl:apply-templates select="./*"></xsl:apply-templates>
			</body>
		</html>
	</xsl:template>

	<!-- Template for 'volume' -->
	<xsl:template match="rpp:volume">
		<h1>
			Volume
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
	</xsl:template>

	<!-- Template for 'tablecontents' -->
	<xsl:template match="rpp:tablecontents">
		<ul>
			<xsl:apply-templates select="rpp:link"></xsl:apply-templates>
		</ul>
	</xsl:template>

	<!-- Template for 'link' -->
	<xsl:template match="rpp:link">
		<li>
			<p>
				<a hRef="#{position()}">
					<xsl:value-of select="@text"></xsl:value-of>
				</a>
			</p>
		</li>
	</xsl:template>

	<!-- Template for 'line' -->
	<xsl:template match="rpp:line">
		<xsl:choose>
			<xsl:when test="@type='titleLine'">
				<xsl:call-template name="rpp:titleLine">
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@type='callLine'">
				<xsl:call-template name="rpp:callLine">
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@type='requestLine'">
				<xsl:call-template name="rpp:requestLine">
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<p>
					<a>Unknown type of line</a>
				</p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>