<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Screen' -->
	<xsl:template match="rpp:screen">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Screen.getScreenExternalName')">
					<th>ScreenExternalName</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getDialogType')">
					<th>DialogType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getProgramExternalName')">
					<th>ProgramExternalName</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapType')">
					<th>MapType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getTransactionCode')">
					<th>TransactionCode</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getScreenLineNumber')">
					<th>ScreenLineNumber</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getScreenColumnNumber')">
					<th>ScreenColumnNumber</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getTabs')">
					<th>Tabs</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelPresentation')">
					<th>LabelPresentation</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getInitialCharacter')">
					<th>InitialCharacter</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getHelpCharacterScreen')">
					<th>HelpCharacterScreen</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getHelpCharacterElement')">
					<th>HelpCharacterElement</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelIntensityAttribute')">
					<th>LabelIntensityAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelColorAttribute')">
					<th>LabelColorAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelPresentationAttribute')">
					<th>LabelPresentationAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getInputIntensityAttribute')">
					<th>InputIntensityAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getInputColorAttribute')">
					<th>InputColorAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getInputPresentationAttribute')">
					<th>InputPresentationAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayIntensityAttribute')">
					<th>DisplayIntensityAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayColorAttribute')">
					<th>DisplayColorAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayPresentationAttribute')">
					<th>DisplayPresentationAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessageIntensityAttribute')">
					<th>ErrorMessageIntensityAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessageColorAttribute')">
					<th>ErrorMessageColorAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessagePresentationAttribute')">
					<th>ErrorMessagePresentationAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldIntensityAttribute')">
					<th>ErrorFieldIntensityAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldColorAttribute')">
					<th>ErrorFieldColorAttribute</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldPresentationAttribute')">
					<th>ErrorFieldPresentationAttribute</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapFolder')">
					<th>MapFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapProject')">
					<th>MapProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Screen.getDialog')">
					<th>Dialog</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialog.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Screen.getScreenExternalName')">
				<td>
					<xsl:value-of select="@screenexternalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getDialogType')">
				<td>
					<xsl:value-of select="@dialogtype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getProgramExternalName')">
				<td>
					<xsl:value-of select="@programexternalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapType')">
				<td>
					<xsl:value-of select="@maptype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getTransactionCode')">
				<td>
					<xsl:value-of select="@transactioncode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getScreenLineNumber')">
				<td>
					<xsl:value-of select="@screenlinenumber"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getScreenColumnNumber')">
				<td>
					<xsl:value-of select="@screencolumnnumber"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getTabs')">
				<td>
					<xsl:value-of select="@tabs"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelPresentation')">
				<td>
					<xsl:value-of select="@labelpresentation"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getInitialCharacter')">
				<td>
					<xsl:value-of select="@initialcharacter"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getHelpCharacterScreen')">
				<td>
					<xsl:value-of select="@helpcharacterscreen"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getHelpCharacterElement')">
				<td>
					<xsl:value-of select="@helpcharacterelement"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelIntensityAttribute')">
				<td>
					<xsl:value-of select="@labelintensityattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelColorAttribute')">
				<td>
					<xsl:value-of select="@labelcolorattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getLabelPresentationAttribute')">
				<td>
					<xsl:value-of select="@labelpresentationattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getInputIntensityAttribute')">
				<td>
					<xsl:value-of select="@inputintensityattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getInputColorAttribute')">
				<td>
					<xsl:value-of select="@inputcolorattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getInputPresentationAttribute')">
				<td>
					<xsl:value-of select="@inputpresentationattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayIntensityAttribute')">
				<td>
					<xsl:value-of select="@displayintensityattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayColorAttribute')">
				<td>
					<xsl:value-of select="@displaycolorattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getDisplayPresentationAttribute')">
				<td>
					<xsl:value-of select="@displaypresentationattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessageIntensityAttribute')">
				<td>
					<xsl:value-of select="@errormessageintensityattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessageColorAttribute')">
				<td>
					<xsl:value-of select="@errormessagecolorattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorMessagePresentationAttribute')">
				<td>
					<xsl:value-of select="@errormessagepresentationattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldIntensityAttribute')">
				<td>
					<xsl:value-of select="@errorfieldintensityattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldColorAttribute')">
				<td>
					<xsl:value-of select="@errorfieldcolorattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getErrorFieldPresentationAttribute')">
				<td>
					<xsl:value-of select="@errorfieldpresentationattribute"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapFolder')">
				<td>
					<xsl:value-of select="@mapfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialog.getMapProject')">
				<td>
					<xsl:value-of select="@mapproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Screen.getDialog')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:screen_dialog/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialog.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractdialog_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>