<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Report' -->
	<xsl:template match="rpp:report">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getType')">
					<th>Type</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getNature')">
					<th>Nature</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getLabelLength')">
					<th>LabelLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getIntegerPartLength')">
					<th>IntegerPartLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getDecimalPartLength')">
					<th>DecimalPartLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getComment')">
					<th>Comment</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getLineLength')">
					<th>LineLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getLinesPerPage')">
					<th>LinesPerPage</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getTableSize')">
					<th>TableSize</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getSectionPriority')">
					<th>SectionPriority</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getEditionComment')">
					<th>EditionComment</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getWriteOption')">
					<th>WriteOption</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Report.getEditionCondition')">
					<th>EditionCondition</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getType')">
				<td>
					<xsl:value-of select="@type"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getNature')">
				<td>
					<xsl:value-of select="@nature"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getLabelLength')">
				<td>
					<xsl:value-of select="@labellength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getIntegerPartLength')">
				<td>
					<xsl:value-of select="@integerpartlength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getDecimalPartLength')">
				<td>
					<xsl:value-of select="@decimalpartlength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getComment')">
				<td>
					<xsl:value-of select="@comment"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getLineLength')">
				<td>
					<xsl:value-of select="@linelength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getLinesPerPage')">
				<td>
					<xsl:value-of select="@linesperpage"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getTableSize')">
				<td>
					<xsl:value-of select="@tablesize"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getSectionPriority')">
				<td>
					<xsl:value-of select="@sectionpriority"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getEditionComment')">
				<td>
					<xsl:value-of select="@editioncomment"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getWriteOption')">
				<td>
					<xsl:value-of select="@writeoption"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Report.getEditionCondition')">
				<td>
					<xsl:value-of select="@editioncondition"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>