<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:rpp="https://com.ibm.pdp.pac.publishing"
	version="1.0" exclude-result-prefixes="xsi rpp">
	<xsl:output omit-xml-declaration="yes" />

	<xsl:param name="output.title"></xsl:param>
	<xsl:param name="output.features"></xsl:param>

	<!-- Publishing template -->
	<xsl:template match="rpp:publishing">
		<html>
			<head>
				<title><xsl:value-of select="$output.title" /></title>
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"></meta>
				<link rel="stylesheet" href="rpp.css" type="text/css"></link>
			</head>
			<body>
				<xsl:if test="count(rpp:codasylblockbase) > 0">
					<h1>List Of CodasylBlockBases</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:codasylblockbase"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:communicationmonitor) > 0">
					<h1>List Of CommunicationMonitors</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:communicationmonitor"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:copybook) > 0">
					<h1>List Of CopyBooks</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:copybook"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dataelement) > 0">
					<h1>List Of DataElements</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dataelement"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:datastructure) > 0">
					<h1>List Of DataStructures</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:datastructure"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dialog) > 0">
					<h1>List Of Dialogs</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dialog"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dialogcommunicationmonitor) > 0">
					<h1>List Of DialogCommunicationMonitors</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dialogcommunicationmonitor"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dialogfolder) > 0">
					<h1>List Of DialogFolders</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dialogfolder"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dialogfolderview) > 0">
					<h1>List Of DialogFolderViews</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dialogfolderview"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:dialogserver) > 0">
					<h1>List Of DialogServers</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:dialogserver"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:errorlabel) > 0">
					<h1>List Of ErrorLabels</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:errorlabel"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:folder) > 0">
					<h1>List Of Folders</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:folder"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:folderview) > 0">
					<h1>List Of FolderViews</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:folderview"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:hierarchicalblockbase) > 0">
					<h1>List Of HierarchicalBlockBases</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:hierarchicalblockbase"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:inputaid) > 0">
					<h1>List Of InputAids</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:inputaid"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:library) > 0">
					<h1>List Of Libraries</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:library"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:logicalview) > 0">
					<h1>List Of LogicalViews</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:logicalview"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:macro) > 0">
					<h1>List Of Macros</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:macro"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:metadataaggregate) > 0">
					<h1>List Of MetaDataAggregates</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:metadataaggregate"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:metaentity) > 0">
					<h1>List Of MetaEntities</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:metaentity"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:metaentitytype) > 0">
					<h1>List Of MetaEntityTypes</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:metaentitytype"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:monostructuresegment) > 0">
					<h1>List Of MonoStructureSegments</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:monostructuresegment"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:program) > 0">
					<h1>List Of Programs</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:program"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:relationalblockbase) > 0">
					<h1>List Of RelationalBlockBases</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:relationalblockbase"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:report) > 0">
					<h1>List Of Reports</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:report"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:screen) > 0">
					<h1>List Of Screens</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:screen"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:server) > 0">
					<h1>List Of Servers</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:server"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:socrateblockbase) > 0">
					<h1>List Of SocrateBlockBases</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:socrateblockbase"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:standardsegment) > 0">
					<h1>List Of StandardSegments</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:standardsegment"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:table) > 0">
					<h1>List Of Tables</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:table"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:text) > 0">
					<h1>List Of Texts</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:text"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:userentity) > 0">
					<h1>List Of UserEntities</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:userentity"></xsl:apply-templates>
					</table>
				</xsl:if>
				<xsl:if test="count(rpp:volume) > 0">
					<h1>List Of Volumes</h1>
					<table border="1">
						<xsl:apply-templates select="rpp:volume"></xsl:apply-templates>
					</table>
				</xsl:if>
			</body>
		</html>
	</xsl:template>

	<!-- Template for 'artifact.link' transformation -->
	<xsl:template name="rpp:artifact.link">
		<xsl:param name="idref"></xsl:param>
		<a hRef="#{$idref}">
			<xsl:value-of select="$idref"></xsl:value-of>
		</a>
	</xsl:template>

</xsl:stylesheet>