<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Program' -->
	<xsl:template match="rpp:program">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getProgramId')">
					<th>ProgramId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getVariant')">
					<th>Variant</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getProgramStructure')">
					<th>ProgramStructure</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getPresenceValidation')">
					<th>PresenceValidation</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getSQLIndicator')">
					<th>SQLIndicator</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Program.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getProgramId')">
				<td>
					<xsl:value-of select="@programid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getVariant')">
				<td>
					<xsl:value-of select="@variant"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getProgramStructure')">
				<td>
					<xsl:value-of select="@programstructure"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getPresenceValidation')">
				<td>
					<xsl:value-of select="@presencevalidation"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getSQLIndicator')">
				<td>
					<xsl:value-of select="@sqlindicator"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Program.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:program_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>