<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'MetaEntityType' -->
	<xsl:template match="rpp:metaentitytype">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'MetaEntityType.getTypeNames')">
					<th>TypeNames</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'MetaEntityType.getUserDocumentation')">
					<th>UserDocumentation</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'MetaEntityType.getTypeNames')">
				<td>
					<xsl:value-of select="@typenames"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'MetaEntityType.getUserDocumentation')">
				<td>
					<xsl:value-of select="@userdocumentation"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>