<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'LogicalView' -->
	<xsl:template match="rpp:logicalview">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'LogicalView.getTransferDirection')">
					<th>TransferDirection</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getType')">
					<th>Type</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getTableSize')">
					<th>TableSize</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractSegment.getOccurrencesNumber')">
					<th>OccurrencesNumber</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getDataStructure')">
					<th>DataStructure</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractSegment.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'LogicalView.getTransferDirection')">
				<td>
					<xsl:value-of select="@transferdirection"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getType')">
				<td>
					<xsl:value-of select="@type"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getTableSize')">
				<td>
					<xsl:value-of select="@tablesize"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractSegment.getOccurrencesNumber')">
				<td>
					<xsl:value-of select="@occurrencesnumber"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractSegment.getDataStructure')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractsegment_datastructure/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractSegment.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractsegment_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>