<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Library' -->
	<xsl:template match="rpp:library">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getAlphanumericDelimiter')">
					<th>AlphanumericDelimiter</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getGeneratedDateFormat')">
					<th>GeneratedDateFormat</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getMapType')">
					<th>MapType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getGeneratedLanguage')">
					<th>GeneratedLanguage</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getDecimalPointDelimiter')">
					<th>DecimalPointDelimiter</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'Library.getCommentsInsertionOption')">
					<th>CommentsInsertionOption</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getCenturySystemDate')">
					<th>CenturySystemDate</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getCenturyReferenceYear')">
					<th>CenturyReferenceYear</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Library.getCobolFormatting')">
					<th>CobolFormatting</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getAlphanumericDelimiter')">
				<td>
					<xsl:value-of select="@alphanumericdelimiter"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getGeneratedDateFormat')">
				<td>
					<xsl:value-of select="@generateddateformat"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getMapType')">
				<td>
					<xsl:value-of select="@maptype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getGeneratedLanguage')">
				<td>
					<xsl:value-of select="@generatedlanguage"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getDecimalPointDelimiter')">
				<td>
					<xsl:value-of select="@decimalpointdelimiter"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getCommentsInsertionOption')">
				<td>
					<xsl:value-of select="@commentsinsertionoption"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getCenturySystemDate')">
				<td>
					<xsl:value-of select="@centurysystemdate"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getCenturyReferenceYear')">
				<td>
					<xsl:value-of select="@centuryreferenceyear"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Library.getCobolFormatting')">
				<td>
					<xsl:value-of select="@cobolformatting"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>