<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Folder' -->
	<xsl:template match="rpp:folder">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getMapType')">
					<th>MapType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getLockOption')">
					<th>LockOption</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getPaginationMode')">
					<th>PaginationMode</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getExternalName')">
					<th>ExternalName</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getDestinationProject')">
					<th>DestinationProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getDestinationFolder')">
					<th>DestinationFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Folder.getDialogFolder')">
					<th>DialogFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getErrorServer')">
					<th>ErrorServer</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getMapType')">
				<td>
					<xsl:value-of select="@maptype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getLockOption')">
				<td>
					<xsl:value-of select="@lockoption"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getPaginationMode')">
				<td>
					<xsl:value-of select="@paginationmode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getExternalName')">
				<td>
					<xsl:value-of select="@externalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getDestinationProject')">
				<td>
					<xsl:value-of select="@destinationproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getDestinationFolder')">
				<td>
					<xsl:value-of select="@destinationfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Folder.getDialogFolder')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:folder_dialogfolder/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractdialogfolder_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogFolder.getErrorServer')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractdialogfolder_errorserver/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>