<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'ErrorLabel' -->
	<xsl:template match="rpp:errorlabel">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationType')">
					<th>GenerationType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getExternalName')">
					<th>ExternalName</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDesinationFolder')">
					<th>DesinationFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDestinationProject')">
					<th>DestinationProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGeneratedLanguage')">
					<th>GeneratedLanguage</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationOption')">
					<th>GenerationOption</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationLibray')">
					<th>GenerationLibray</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDataStructure')">
					<th>DataStructure</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDialog')">
					<th>Dialog</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDialogServer')">
					<th>DialogServer</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationType')">
				<td>
					<xsl:value-of select="@generationtype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getExternalName')">
				<td>
					<xsl:value-of select="@externalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDesinationFolder')">
				<td>
					<xsl:value-of select="@desinationfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDestinationProject')">
				<td>
					<xsl:value-of select="@destinationproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGeneratedLanguage')">
				<td>
					<xsl:value-of select="@generatedlanguage"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationOption')">
				<td>
					<xsl:value-of select="@generationoption"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getGenerationLibray')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:errorlabel_generationlibray/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDataStructure')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:errorlabel_datastructure/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDialog')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:errorlabel_dialog/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'ErrorLabel.getDialogServer')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:errorlabel_dialogserver/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>