<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'DialogServer' -->
	<xsl:template match="rpp:dialogserver">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DialogServer.getOptions')">
					<th>Options</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'DialogServer.getErrorMessageFileOrganization')">
					<th>ErrorMessageFileOrganization</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'DialogServer.getErrorMessageFileExternalName')">
					<th>ErrorMessageFileExternalName</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'DialogServer.getComplementCommonAreaLength')">
					<th>ComplementCommonAreaLength</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getDialogServerType')">
					<th>DialogServerType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogServer.getMapType')">
					<th>MapType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProgramExternalName')">
					<th>ProgramExternalName</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getTransactionCode')">
					<th>TransactionCode</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProxyProject')">
					<th>ProxyProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProxyFolder')">
					<th>ProxyFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getServiceProject')">
					<th>ServiceProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getServiceFolder')">
					<th>ServiceFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DialogServer.getCommonArea')">
					<th>CommonArea</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'DialogServer.getPsbOrSubSchemaCode')">
					<th>PsbOrSubSchemaCode</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogServer.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DialogServer.getOptions')">
				<td>
					<xsl:value-of select="@options"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'DialogServer.getErrorMessageFileOrganization')">
				<td>
					<xsl:value-of select="@errormessagefileorganization"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'DialogServer.getErrorMessageFileExternalName')">
				<td>
					<xsl:value-of select="@errormessagefileexternalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'DialogServer.getComplementCommonAreaLength')">
				<td>
					<xsl:value-of select="@complementcommonarealength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getDialogServerType')">
				<td>
					<xsl:value-of select="@dialogservertype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractDialogServer.getMapType')">
				<td>
					<xsl:value-of select="@maptype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProgramExternalName')">
				<td>
					<xsl:value-of select="@programexternalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getTransactionCode')">
				<td>
					<xsl:value-of select="@transactioncode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProxyProject')">
				<td>
					<xsl:value-of select="@proxyproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getProxyFolder')">
				<td>
					<xsl:value-of select="@proxyfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getServiceProject')">
				<td>
					<xsl:value-of select="@serviceproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getServiceFolder')">
				<td>
					<xsl:value-of select="@servicefolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DialogServer.getCommonArea')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:dialogserver_commonarea/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DialogServer.getPsbOrSubSchemaCode')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:dialogserver_psborsubschemacode/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogServer.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractdialogserver_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>