<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'DialogCommunicationMonitor' -->
	<xsl:template match="rpp:dialogcommunicationmonitor">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getMessageSize')">
					<th>MessageSize</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getErrorMessageSent')">
					<th>ErrorMessageSent</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getMapType')">
					<th>MapType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getExternalName')">
					<th>ExternalName</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCommunicationType')">
					<th>CommunicationType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getTransactionCode')">
					<th>TransactionCode</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getMessageSize')">
				<td>
					<xsl:value-of select="@messagesize"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getErrorMessageSent')">
				<td>
					<xsl:value-of select="@errormessagesent"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getMapType')">
				<td>
					<xsl:value-of select="@maptype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getExternalName')">
				<td>
					<xsl:value-of select="@externalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCommunicationType')">
				<td>
					<xsl:value-of select="@communicationtype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getTransactionCode')">
				<td>
					<xsl:value-of select="@transactioncode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractDialogCommunicationMonitor.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref"
							select="rpp:abstractdialogcommunicationmonitor_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>