<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'DataElement' -->
	<xsl:template match="rpp:dataelement">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getType')">
					<th>Type</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalFormat')">
					<th>InternalFormat</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalUsage')">
					<th>InternalUsage</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInputFormat')">
					<th>InputFormat</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getOutputFormat')">
					<th>OutputFormat</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getBlankWhenZero')">
					<th>BlankWhenZero</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalLength')">
					<th>InternalLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInputLength')">
					<th>InputLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getOutputLength')">
					<th>OutputLength</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getParent')">
					<th>Parent</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getType')">
				<td>
					<xsl:value-of select="@type"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalFormat')">
				<td>
					<xsl:value-of select="@internalformat"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalUsage')">
				<td>
					<xsl:value-of select="@internalusage"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInputFormat')">
				<td>
					<xsl:value-of select="@inputformat"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getOutputFormat')">
				<td>
					<xsl:value-of select="@outputformat"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getBlankWhenZero')">
				<td>
					<xsl:value-of select="@blankwhenzero"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInternalLength')">
				<td>
					<xsl:value-of select="@internallength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getInputLength')">
				<td>
					<xsl:value-of select="@inputlength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getOutputLength')">
				<td>
					<xsl:value-of select="@outputlength"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getParent')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:dataelement_parent/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'DataElement.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:dataelement_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>