<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'Copybook' -->
	<xsl:template match="rpp:copybook">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolProject')">
					<th>CobolProject</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolFolder')">
					<th>CobolFolder</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getGenerationType')">
					<th>GenerationType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDSCodeType')">
					<th>DSCodeType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getExternalName')">
					<th>ExternalName</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolLocationCode')">
					<th>CobolLocationCode</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolType')">
					<th>CobolType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getFormatType')">
					<th>FormatType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getRecordType')">
					<th>RecordType</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getRecordLevel')">
					<th>RecordLevel</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getPresIndicator')">
					<th>PresIndicator</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDataStructureCode')">
					<th>DataStructureCode</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDataStructure')">
					<th>DataStructure</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getBlockBase')">
					<th>BlockBase</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolProject')">
				<td>
					<xsl:value-of select="@cobolproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolFolder')">
				<td>
					<xsl:value-of select="@cobolfolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getGenerationType')">
				<td>
					<xsl:value-of select="@generationtype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDSCodeType')">
				<td>
					<xsl:value-of select="@dscodetype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getExternalName')">
				<td>
					<xsl:value-of select="@externalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolLocationCode')">
				<td>
					<xsl:value-of select="@cobollocationcode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getCobolType')">
				<td>
					<xsl:value-of select="@coboltype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getFormatType')">
				<td>
					<xsl:value-of select="@formattype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getRecordType')">
				<td>
					<xsl:value-of select="@recordtype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getRecordLevel')">
				<td>
					<xsl:value-of select="@recordlevel"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getPresIndicator')">
				<td>
					<xsl:value-of select="@presindicator"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDataStructureCode')">
				<td>
					<xsl:value-of select="@datastructurecode"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:copybook_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getDataStructure')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:copybook_datastructure/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'Copybook.getBlockBase')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:copybook_blockbase/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>