<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing_list.xsl"></xsl:import>

	<!-- Template for the class: 'CodasylBlockBase' -->
	<xsl:template match="rpp:codasylblockbase">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<tr>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
					<th>Project</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
					<th>Name</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
					<th>Label</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'CodasylBlockBase.getSchemaNumber')">
					<th>SchemaNumber</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getExternalName')">
					<th>ExternalName</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getBlockType')">
					<th>BlockType</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractBlockBase.getVersionNumber')">
					<th>VersionNumber</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getType')">
					<th>Type</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerateFolder')">
					<th>GenerateFolder</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerateProject')">
					<th>GenerateProject</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerationOption')">
					<th>GenerationOption</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
					<th>DesignId</th>
				</xsl:if>
				<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
					<th>EntityVersion</th>
				</xsl:if>
				<xsl:if
					test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerationLibrary')">
					<th>GenerationLibrary</th>
				</xsl:if>
			</tr>
		</xsl:if>
		<tr>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getProject')">
				<td id="{@id}">
					<xsl:value-of select="@project"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getName')">
				<td>
					<xsl:value-of select="@name"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getLabel')">
				<td>
					<xsl:value-of select="@label"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'CodasylBlockBase.getSchemaNumber')">
				<td>
					<xsl:value-of select="@schemanumber"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getExternalName')">
				<td>
					<xsl:value-of select="@externalname"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getBlockType')">
				<td>
					<xsl:value-of select="@blocktype"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getVersionNumber')">
				<td>
					<xsl:value-of select="@versionnumber"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'AbstractBlockBase.getType')">
				<td>
					<xsl:value-of select="@type"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerateFolder')">
				<td>
					<xsl:value-of select="@generatefolder"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerateProject')">
				<td>
					<xsl:value-of select="@generateproject"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerationOption')">
				<td>
					<xsl:value-of select="@generationoption"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getDesignId')">
				<td>
					<xsl:value-of select="@designid"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if test="$output.features='' or contains($output.features, 'RadicalElement.getEntityVersion')">
				<td>
					<xsl:value-of select="@entityversion"></xsl:value-of>
				</td>
			</xsl:if>
			<xsl:if
				test="$output.features='' or contains($output.features, 'AbstractBlockBase.getGenerationLibrary')">
				<td>
					<xsl:call-template name="rpp:artifact.link">
						<xsl:with-param name="idref" select="rpp:abstractblockbase_generationlibrary/@idref"></xsl:with-param>
					</xsl:call-template>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
</xsl:stylesheet>