<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Volume' -->
	<xsl:template match="rpp:volume">
		<h1 id="{@id}">
			Volume
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:volume_dlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'Filter' -->
	<xsl:template match="rpp:callline_filter">
		<p>
			<b>Filter</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefilter"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Filter' -->
	<xsl:template match="rpp:requestline_filter">
		<p>
			<b>Filter</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefilter"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Request' -->
	<xsl:template match="rpp:requestline_request">
		<p>
			<b>Request</b>
		</p>
		<xsl:choose>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.VolumeReferenceRequest'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumereferencerequest"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.VolumeSearchRequest'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumesearchrequest"></xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Template for the relation: 'WhereFields' -->
	<xsl:template match="rpp:callline_wherefields">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>WhereFields</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>VolumeField</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefield"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'RetainedFeatures' -->
	<xsl:template match="rpp:volumeclass_retainedfeatures">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>RetainedFeatures</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>VolumeFeature</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefeature"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Classes' -->
	<xsl:template match="rpp:volumefilter_classes">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Classes</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:value-of select="."></xsl:value-of>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'RetainedClasses' -->
	<xsl:template match="rpp:volumefilter_retainedclasses">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>RetainedClasses</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>VolumeClass</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumeclass"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'SearchFor' -->
	<xsl:template match="rpp:volumesearchrequest_searchfor">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SearchFor</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:value-of select="."></xsl:value-of>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DLines' -->
	<xsl:template match="rpp:volume_dlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.AssignedTextLine'">
							<b>AssignedTextLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.assignedtextline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.CallLine'">
							<b>CallLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.callline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.OptionLine'">
							<b>OptionLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.optionline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.RequestLine'">
							<b>RequestLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.requestline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.volume.TitleLine'">
							<b>TitleLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.titleline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.AssignedTextLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.assignedtextline">
		<table>
			<xsl:if test="@nblinebreak != ''">
				<tr>
					<td class="row_cell">NbLineBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@nblinebreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:assignedtextline_assignedfrom/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>AssignedFrom</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:assignedtextline_assignedfrom/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.CallLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.callline">
		<table>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nblinebreak != ''">
				<tr>
					<td class="row_cell">NbLineBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@nblinebreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:callline_calledinstance/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>CalledInstance</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:callline_calledinstance/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:callline_filter"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:callline_wherefields"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.OptionLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.optionline">
		<table>
			<xsl:if test="@options != ''">
				<tr>
					<td class="row_cell">Options</td>
					<td class="row_cell">
						<xsl:value-of select="@options"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nblinebreak != ''">
				<tr>
					<td class="row_cell">NbLineBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@nblinebreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.RequestLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.requestline">
		<table>
			<xsl:if test="@nblinebreak != ''">
				<tr>
					<td class="row_cell">NbLineBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@nblinebreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:requestline_filter"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:requestline_request"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.TitleLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.titleline">
		<table>
			<xsl:if test="@level != ''">
				<tr>
					<td class="row_cell">Level</td>
					<td class="row_cell">
						<xsl:value-of select="@level"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@text != ''">
				<tr>
					<td class="row_cell">Text</td>
					<td class="row_cell">
						<xsl:value-of select="@text"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nblinebreak != ''">
				<tr>
					<td class="row_cell">NbLineBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@nblinebreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeClass' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumeclass">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:volumeclass_retainedfeatures"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeFeature' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefeature">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeField' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefield">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeFilter' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumefilter">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:volumefilter_classes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:volumefilter_retainedclasses"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeReferenceRequest' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumereferencerequest">
		<table>
			<xsl:if test="@direction != ''">
				<tr>
					<td class="row_cell">Direction</td>
					<td class="row_cell">
						<xsl:value-of select="@direction"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:volumereferencerequest_frominstance/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>FromInstance</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:volumereferencerequest_frominstance/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.volume.VolumeSearchRequest' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.volume.volumesearchrequest">
		<table>
			<xsl:if test="@expression != ''">
				<tr>
					<td class="row_cell">Expression</td>
					<td class="row_cell">
						<xsl:value-of select="@expression"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@limitto != ''">
				<tr>
					<td class="row_cell">LimitTo</td>
					<td class="row_cell">
						<xsl:value-of select="@limitto"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@context != ''">
				<tr>
					<td class="row_cell">Context</td>
					<td class="row_cell">
						<xsl:value-of select="@context"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@vision != ''">
				<tr>
					<td class="row_cell">Vision</td>
					<td class="row_cell">
						<xsl:value-of select="@vision"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:volumesearchrequest_searchfor"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>