<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Text' -->
	<xsl:template match="rpp:text">
		<h1 id="{@id}">
			Text
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@texttype != ''">
				<tr>
					<td class="row_cell">TextType</td>
					<td class="row_cell">
						<xsl:value-of select="@texttype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sectiontype != ''">
				<tr>
					<td class="row_cell">SectionType</td>
					<td class="row_cell">
						<xsl:value-of select="@sectiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:text_sections"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'Sections' -->
	<xsl:template match="rpp:text_sections">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Sections</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Section</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.text.section"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.text.Section' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.text.section">
		<table>
			<xsl:if test="@code != ''">
				<tr>
					<td class="row_cell">Code</td>
					<td class="row_cell">
						<xsl:value-of select="@code"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@source != ''">
				<tr>
					<td class="row_cell">Source</td>
					<td class="row_cell">
						<xsl:value-of select="@source"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>