<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing.xsl"></xsl:import>

	<!-- Template for 'table contents' -->
	<xsl:template match="rpp:tablecontents">
		<h1>Table Of Contents</h1>
		<ul>
			<xsl:apply-templates select="rpp:artifact"></xsl:apply-templates>
		</ul>
	</xsl:template>

	<!-- Template for 'artifact' -->
	<xsl:template match="rpp:artifact">
		<li>
			<p>
				<xsl:call-template name="rpp:tablecontents.link">
					<xsl:with-param name="idref" select="@idref" />
				</xsl:call-template>
			</p>
		</li>
	</xsl:template>

	<!-- Template for tablecontents.link transformation' -->
	<xsl:template name="rpp:tablecontents.link">
		<xsl:param name="idref" />
		<xsl:choose>
			<xsl:when test="$output.structure='folder'">
				<a hRef="{$idref}.html#{$idref}">
					<xsl:value-of select="$idref"></xsl:value-of>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<a hRef="#{$idref}">
					<xsl:value-of select="$idref"></xsl:value-of>
				</a>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>