<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractSegment.xsl"></xsl:import>

	<!-- Template for the class: 'Table' -->
	<xsl:template match="rpp:table">
		<h1 id="{@id}">
			Table
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tablenumber != ''">
				<tr>
					<td class="row_cell">TableNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@tablenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatefolder != ''">
				<tr>
					<td class="row_cell">GenerateFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@generatefolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateproject != ''">
				<tr>
					<td class="row_cell">GenerateProject</td>
					<td class="row_cell">
						<xsl:value-of select="@generateproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tablesize != ''">
				<tr>
					<td class="row_cell">TableSize</td>
					<td class="row_cell">
						<xsl:value-of select="@tablesize"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurrencesnumber != ''">
				<tr>
					<td class="row_cell">OccurrencesNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@occurrencesnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractsegment_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractsegment_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:abstractsegment_statistics"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:table_sslines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_celines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_leveladdresslength"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'SSLines' -->
	<xsl:template match="rpp:table_sslines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SSLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>SubSchemaAndSubSystem</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.subschemaandsubsystem"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.SubSchemaAndSubSystem' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.subschemaandsubsystem">
		<table>
			<xsl:if test="@tablelinetype != ''">
				<tr>
					<td class="row_cell">TableLineType</td>
					<td class="row_cell">
						<xsl:value-of select="@tablelinetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@number != ''">
				<tr>
					<td class="row_cell">Number</td>
					<td class="row_cell">
						<xsl:value-of select="@number"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschemaorsubsystemname != ''">
				<tr>
					<td class="row_cell">SubSchemaOrSubSystemName</td>
					<td class="row_cell">
						<xsl:value-of select="@subschemaorsubsystemname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maxoccurencesnumber != ''">
				<tr>
					<td class="row_cell">MaxOccurencesNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@maxoccurencesnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>