<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractSegment.xsl"></xsl:import>

	<!-- Template for the class: 'StandardSegment' -->
	<xsl:template match="rpp:standardsegment">
		<h1 id="{@id}">
			StandardSegment
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@actioncodevalue != ''">
				<tr>
					<td class="row_cell">ActionCodeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@actioncodevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@structurecodevalue != ''">
				<tr>
					<td class="row_cell">StructureCodeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@structurecodevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceincreation != ''">
				<tr>
					<td class="row_cell">PresenceInCreation</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceincreation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceinmodification != ''">
				<tr>
					<td class="row_cell">PresenceInModification</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceinmodification"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceindeletion != ''">
				<tr>
					<td class="row_cell">PresenceInDeletion</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceindeletion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceintype4 != ''">
				<tr>
					<td class="row_cell">PresenceInType4</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceintype4"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceintype5 != ''">
				<tr>
					<td class="row_cell">PresenceInType5</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceintype5"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presenceintype6 != ''">
				<tr>
					<td class="row_cell">PresenceInType6</td>
					<td class="row_cell">
						<xsl:value-of select="@presenceintype6"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tablesize != ''">
				<tr>
					<td class="row_cell">TableSize</td>
					<td class="row_cell">
						<xsl:value-of select="@tablesize"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurrencesnumber != ''">
				<tr>
					<td class="row_cell">OccurrencesNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@occurrencesnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractsegment_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractsegment_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:abstractsegment_statistics"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractsegment_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_celines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_leveladdresslength"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>