<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractBlockBase.xsl"></xsl:import>

	<!-- Template for the class: 'SocrateBlockBase' -->
	<xsl:template match="rpp:socrateblockbase">
		<h1 id="{@id}">
			SocrateBlockBase
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blocktype != ''">
				<tr>
					<td class="row_cell">BlockType</td>
					<td class="row_cell">
						<xsl:value-of select="@blocktype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@versionnumber != ''">
				<tr>
					<td class="row_cell">VersionNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@versionnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatefolder != ''">
				<tr>
					<td class="row_cell">GenerateFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@generatefolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateproject != ''">
				<tr>
					<td class="row_cell">GenerateProject</td>
					<td class="row_cell">
						<xsl:value-of select="@generateproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationoption != ''">
				<tr>
					<td class="row_cell">GenerationOption</td>
					<td class="row_cell">
						<xsl:value-of select="@generationoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractblockbase_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractblockbase_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:socrateblockbase_dhlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:dhline_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DHLines' -->
	<xsl:template match="rpp:socrateblockbase_dhlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DHLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DHLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.dhline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.blockbase.DHLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.dhline">
		<table>
			<xsl:if test="@relationcode != ''">
				<tr>
					<td class="row_cell">RelationCode</td>
					<td class="row_cell">
						<xsl:value-of select="@relationcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@keyindicatororoption != ''">
				<tr>
					<td class="row_cell">KeyIndicatorOrOption</td>
					<td class="row_cell">
						<xsl:value-of select="@keyindicatororoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@estimatednumberoflink != ''">
				<tr>
					<td class="row_cell">EstimatedNumberOfLink</td>
					<td class="row_cell">
						<xsl:value-of select="@estimatednumberoflink"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@commentsorrelationshiporkeylength != ''">
				<tr>
					<td class="row_cell">CommentsOrRelationShipOrKeyLength</td>
					<td class="row_cell">
						<xsl:value-of select="@commentsorrelationshiporkeylength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dhline_pcborpsbcode/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>PCBorPSBCode</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dhline_pcborpsbcode/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dhline_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dhline_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dhline_parentsegment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>ParentSegment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dhline_parentsegment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dhline_gglines"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>