<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractDialogServer.xsl"></xsl:import>

	<!-- Template for the class: 'Server' -->
	<xsl:template match="rpp:server">
		<h1 id="{@id}">
			Server
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serverexternalname != ''">
				<tr>
					<td class="row_cell">ServerExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@serverexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@dialogservertype != ''">
				<tr>
					<td class="row_cell">DialogServerType</td>
					<td class="row_cell">
						<xsl:value-of select="@dialogservertype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programexternalname != ''">
				<tr>
					<td class="row_cell">ProgramExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@programexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transactioncode != ''">
				<tr>
					<td class="row_cell">TransactionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@transactioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@proxyproject != ''">
				<tr>
					<td class="row_cell">ProxyProject</td>
					<td class="row_cell">
						<xsl:value-of select="@proxyproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@proxyfolder != ''">
				<tr>
					<td class="row_cell">ProxyFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@proxyfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serviceproject != ''">
				<tr>
					<td class="row_cell">ServiceProject</td>
					<td class="row_cell">
						<xsl:value-of select="@serviceproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@servicefolder != ''">
				<tr>
					<td class="row_cell">ServiceFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@servicefolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:server_dialogserver/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DialogServer</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:server_dialogserver/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractdialogserver_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractdialogserver_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractdialogserver_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogserver_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogserver_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogserver_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogserver_cslines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>