<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractDialog.xsl"></xsl:import>

	<!-- Template for the class: 'Screen' -->
	<xsl:template match="rpp:screen">
		<h1 id="{@id}">
			Screen
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenexternalname != ''">
				<tr>
					<td class="row_cell">ScreenExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@screenexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@dialogtype != ''">
				<tr>
					<td class="row_cell">DialogType</td>
					<td class="row_cell">
						<xsl:value-of select="@dialogtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programexternalname != ''">
				<tr>
					<td class="row_cell">ProgramExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@programexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transactioncode != ''">
				<tr>
					<td class="row_cell">TransactionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@transactioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenlinenumber != ''">
				<tr>
					<td class="row_cell">ScreenLineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@screenlinenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screencolumnnumber != ''">
				<tr>
					<td class="row_cell">ScreenColumnNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@screencolumnnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tabs != ''">
				<tr>
					<td class="row_cell">Tabs</td>
					<td class="row_cell">
						<xsl:value-of select="@tabs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentation != ''">
				<tr>
					<td class="row_cell">LabelPresentation</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@initialcharacter != ''">
				<tr>
					<td class="row_cell">InitialCharacter</td>
					<td class="row_cell">
						<xsl:value-of select="@initialcharacter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@helpcharacterscreen != ''">
				<tr>
					<td class="row_cell">HelpCharacterScreen</td>
					<td class="row_cell">
						<xsl:value-of select="@helpcharacterscreen"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@helpcharacterelement != ''">
				<tr>
					<td class="row_cell">HelpCharacterElement</td>
					<td class="row_cell">
						<xsl:value-of select="@helpcharacterelement"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelintensityattribute != ''">
				<tr>
					<td class="row_cell">LabelIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelcolorattribute != ''">
				<tr>
					<td class="row_cell">LabelColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationattribute != ''">
				<tr>
					<td class="row_cell">LabelPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputintensityattribute != ''">
				<tr>
					<td class="row_cell">InputIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputcolorattribute != ''">
				<tr>
					<td class="row_cell">InputColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputpresentationattribute != ''">
				<tr>
					<td class="row_cell">InputPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayintensityattribute != ''">
				<tr>
					<td class="row_cell">DisplayIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displayintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displaycolorattribute != ''">
				<tr>
					<td class="row_cell">DisplayColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displaycolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displaypresentationattribute != ''">
				<tr>
					<td class="row_cell">DisplayPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displaypresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessageintensityattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessageIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessageintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagecolorattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessageColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagecolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagepresentationattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessagePresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagepresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldintensityattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldcolorattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldpresentationattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@mapfolder != ''">
				<tr>
					<td class="row_cell">MapFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@mapfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@mapproject != ''">
				<tr>
					<td class="row_cell">MapProject</td>
					<td class="row_cell">
						<xsl:value-of select="@mapproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:screen_dialog/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Dialog</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:screen_dialog/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractdialog_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractdialog_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:screen_celines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_cslines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'Complements' -->
	<xsl:template match="rpp:celinefield_complements">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Complements</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CELineFieldComplement</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefieldcomplement"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Indicators' -->
	<xsl:template match="rpp:celinefield_indicators">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Indicators</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CELineFieldIndicator</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefieldindicator"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CELines' -->
	<xsl:template match="rpp:screen_celines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.CELineCategory'">
							<b>CELineCategory</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinecategory"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.CELineField'">
							<b>CELineField</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefield"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.CELineLabel'">
							<b>CELineLabel</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinelabel"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.CELineScreenCall'">
							<b>CELineScreenCall</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinescreencall"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineCategory' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinecategory">
		<table>
			<xsl:if test="@categoryname != ''">
				<tr>
					<td class="row_cell">CategoryName</td>
					<td class="row_cell">
						<xsl:value-of select="@categoryname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@categorynature != ''">
				<tr>
					<td class="row_cell">CategoryNature</td>
					<td class="row_cell">
						<xsl:value-of select="@categorynature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@horizontalrepetition != ''">
				<tr>
					<td class="row_cell">HorizontalRepetition</td>
					<td class="row_cell">
						<xsl:value-of select="@horizontalrepetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@verticalrepetition != ''">
				<tr>
					<td class="row_cell">VerticalRepetition</td>
					<td class="row_cell">
						<xsl:value-of select="@verticalrepetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldintensityattribute != ''">
				<tr>
					<td class="row_cell">FieldIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldcolorattribute != ''">
				<tr>
					<td class="row_cell">FieldColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldpresentationattribute != ''">
				<tr>
					<td class="row_cell">FieldPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelintensityattribute != ''">
				<tr>
					<td class="row_cell">LabelIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelcolorattribute != ''">
				<tr>
					<td class="row_cell">LabelColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationattribute != ''">
				<tr>
					<td class="row_cell">LabelPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@columnposition != ''">
				<tr>
					<td class="row_cell">ColumnPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@columnposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@lineposition != ''">
				<tr>
					<td class="row_cell">LinePosition</td>
					<td class="row_cell">
						<xsl:value-of select="@lineposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@positiontype != ''">
				<tr>
					<td class="row_cell">PositionType</td>
					<td class="row_cell">
						<xsl:value-of select="@positiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationvalue != ''">
				<tr>
					<td class="row_cell">LabelPresentationValue</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineField' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefield">
		<table>
			<xsl:if test="@fieldnature != ''">
				<tr>
					<td class="row_cell">FieldNature</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldnature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldtype != ''">
				<tr>
					<td class="row_cell">FieldType</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cursor != ''">
				<tr>
					<td class="row_cell">Cursor</td>
					<td class="row_cell">
						<xsl:value-of select="@cursor"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@horizontalrepetition != ''">
				<tr>
					<td class="row_cell">HorizontalRepetition</td>
					<td class="row_cell">
						<xsl:value-of select="@horizontalrepetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@verticalrepetition != ''">
				<tr>
					<td class="row_cell">VerticalRepetition</td>
					<td class="row_cell">
						<xsl:value-of select="@verticalrepetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@initialvalue != ''">
				<tr>
					<td class="row_cell">InitialValue</td>
					<td class="row_cell">
						<xsl:value-of select="@initialvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@simulationvalue != ''">
				<tr>
					<td class="row_cell">SimulationValue</td>
					<td class="row_cell">
						<xsl:value-of select="@simulationvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldintensityattribute != ''">
				<tr>
					<td class="row_cell">FieldIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldcolorattribute != ''">
				<tr>
					<td class="row_cell">FieldColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldpresentationattribute != ''">
				<tr>
					<td class="row_cell">FieldPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelintensityattribute != ''">
				<tr>
					<td class="row_cell">LabelIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelcolorattribute != ''">
				<tr>
					<td class="row_cell">LabelColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationattribute != ''">
				<tr>
					<td class="row_cell">LabelPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@indattributeposition != ''">
				<tr>
					<td class="row_cell">IndAttributePosition</td>
					<td class="row_cell">
						<xsl:value-of select="@indattributeposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@columnposition != ''">
				<tr>
					<td class="row_cell">ColumnPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@columnposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@lineposition != ''">
				<tr>
					<td class="row_cell">LinePosition</td>
					<td class="row_cell">
						<xsl:value-of select="@lineposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@positiontype != ''">
				<tr>
					<td class="row_cell">PositionType</td>
					<td class="row_cell">
						<xsl:value-of select="@positiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationvalue != ''">
				<tr>
					<td class="row_cell">LabelPresentationValue</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:celinefield_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:celinefield_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:celinefield_complements"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:celinefield_indicators"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineFieldComplement' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefieldcomplement">
		<table>
			<xsl:if test="@presencecheck != ''">
				<tr>
					<td class="row_cell">PresenceCheck</td>
					<td class="row_cell">
						<xsl:value-of select="@presencecheck"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@actioncode != ''">
				<tr>
					<td class="row_cell">ActionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@actioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@updateoption != ''">
				<tr>
					<td class="row_cell">UpdateOption</td>
					<td class="row_cell">
						<xsl:value-of select="@updateoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@updatesegmentcode != ''">
				<tr>
					<td class="row_cell">UpdateSegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@updatesegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sourcetype != ''">
				<tr>
					<td class="row_cell">SourceType</td>
					<td class="row_cell">
						<xsl:value-of select="@sourcetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displaysegmentcode != ''">
				<tr>
					<td class="row_cell">DisplaySegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@displaysegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlevel != ''">
				<tr>
					<td class="row_cell">GeneratedLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:celinefieldcomplement_screen/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Screen</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:celinefieldcomplement_screen/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineFieldIndicator' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinefieldindicator">
		<table>
			<xsl:if test="@indicatornumber != ''">
				<tr>
					<td class="row_cell">IndicatorNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@indicatornumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@switchindicator != ''">
				<tr>
					<td class="row_cell">SwitchIndicator</td>
					<td class="row_cell">
						<xsl:value-of select="@switchindicator"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@attributetype != ''">
				<tr>
					<td class="row_cell">AttributeType</td>
					<td class="row_cell">
						<xsl:value-of select="@attributetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fieldattribute != ''">
				<tr>
					<td class="row_cell">FieldAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@fieldattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@dataattribute != ''">
				<tr>
					<td class="row_cell">DataAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@dataattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineLabel' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinelabel">
		<table>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelnature != ''">
				<tr>
					<td class="row_cell">LabelNature</td>
					<td class="row_cell">
						<xsl:value-of select="@labelnature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@repeatedcharacter != ''">
				<tr>
					<td class="row_cell">RepeatedCharacter</td>
					<td class="row_cell">
						<xsl:value-of select="@repeatedcharacter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@repetition != ''">
				<tr>
					<td class="row_cell">Repetition</td>
					<td class="row_cell">
						<xsl:value-of select="@repetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@intensityattribute != ''">
				<tr>
					<td class="row_cell">IntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@intensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@colorattribute != ''">
				<tr>
					<td class="row_cell">ColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@colorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presentationattribute != ''">
				<tr>
					<td class="row_cell">PresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@presentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@columnposition != ''">
				<tr>
					<td class="row_cell">ColumnPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@columnposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@lineposition != ''">
				<tr>
					<td class="row_cell">LinePosition</td>
					<td class="row_cell">
						<xsl:value-of select="@lineposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@positiontype != ''">
				<tr>
					<td class="row_cell">PositionType</td>
					<td class="row_cell">
						<xsl:value-of select="@positiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationvalue != ''">
				<tr>
					<td class="row_cell">LabelPresentationValue</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:celinelabel_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:celinelabel_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:celinelabel_screen/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Screen</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:celinelabel_screen/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.CELineScreenCall' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.celinescreencall">
		<table>
			<xsl:if test="@columnposition != ''">
				<tr>
					<td class="row_cell">ColumnPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@columnposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@lineposition != ''">
				<tr>
					<td class="row_cell">LinePosition</td>
					<td class="row_cell">
						<xsl:value-of select="@lineposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@positiontype != ''">
				<tr>
					<td class="row_cell">PositionType</td>
					<td class="row_cell">
						<xsl:value-of select="@positiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationvalue != ''">
				<tr>
					<td class="row_cell">LabelPresentationValue</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:celinescreencall_screen/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Screen</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:celinescreencall_screen/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>