<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Report' -->
	<xsl:template match="rpp:report">
		<h1 id="{@id}">
			Report
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nature != ''">
				<tr>
					<td class="row_cell">Nature</td>
					<td class="row_cell">
						<xsl:value-of select="@nature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labellength != ''">
				<tr>
					<td class="row_cell">LabelLength</td>
					<td class="row_cell">
						<xsl:value-of select="@labellength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@integerpartlength != ''">
				<tr>
					<td class="row_cell">IntegerPartLength</td>
					<td class="row_cell">
						<xsl:value-of select="@integerpartlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@decimalpartlength != ''">
				<tr>
					<td class="row_cell">DecimalPartLength</td>
					<td class="row_cell">
						<xsl:value-of select="@decimalpartlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linelength != ''">
				<tr>
					<td class="row_cell">LineLength</td>
					<td class="row_cell">
						<xsl:value-of select="@linelength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linesperpage != ''">
				<tr>
					<td class="row_cell">LinesPerPage</td>
					<td class="row_cell">
						<xsl:value-of select="@linesperpage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tablesize != ''">
				<tr>
					<td class="row_cell">TableSize</td>
					<td class="row_cell">
						<xsl:value-of select="@tablesize"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sectionpriority != ''">
				<tr>
					<td class="row_cell">SectionPriority</td>
					<td class="row_cell">
						<xsl:value-of select="@sectionpriority"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@editioncomment != ''">
				<tr>
					<td class="row_cell">EditionComment</td>
					<td class="row_cell">
						<xsl:value-of select="@editioncomment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@writeoption != ''">
				<tr>
					<td class="row_cell">WriteOption</td>
					<td class="row_cell">
						<xsl:value-of select="@writeoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@editioncondition != ''">
				<tr>
					<td class="row_cell">EditionCondition</td>
					<td class="row_cell">
						<xsl:value-of select="@editioncondition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:report_llines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:report_celines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:report_dlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'Composition' -->
	<xsl:template match="rpp:celine_composition">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Composition</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.report.DataElementCELine'">
							<b>DataElementCELine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.dataelementceline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.report.UndefinedDataElementCELine'">
							<b>UndefinedDataElementCELine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.undefineddataelementceline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'SourceLines' -->
	<xsl:template match="rpp:compositionceline_sourcelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SourceLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>SourceLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.sourceline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'EditionLines' -->
	<xsl:template match="rpp:dline_editionlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>EditionLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>EditionLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.editionline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CELines' -->
	<xsl:template match="rpp:report_celines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CELine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.celine"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DLines' -->
	<xsl:template match="rpp:report_dlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.dline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'LLines' -->
	<xsl:template match="rpp:report_llines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>LLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>LLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.lline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.CELine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.celine">
		<table>
			<xsl:if test="@structureid != ''">
				<tr>
					<td class="row_cell">StructureID</td>
					<td class="row_cell">
						<xsl:value-of select="@structureid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:celine_composition"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.DLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.dline">
		<table>
			<xsl:if test="@categoryid != ''">
				<tr>
					<td class="row_cell">CategoryID</td>
					<td class="row_cell">
						<xsl:value-of select="@categoryid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@categorytype != ''">
				<tr>
					<td class="row_cell">CategoryType</td>
					<td class="row_cell">
						<xsl:value-of select="@categorytype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@repetition != ''">
				<tr>
					<td class="row_cell">Repetition</td>
					<td class="row_cell">
						<xsl:value-of select="@repetition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@categorycondition != ''">
				<tr>
					<td class="row_cell">CategoryCondition</td>
					<td class="row_cell">
						<xsl:value-of select="@categorycondition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dline_editionlines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.DataElementCELine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.dataelementceline">
		<table>
			<xsl:if test="@column != ''">
				<tr>
					<td class="row_cell">Column</td>
					<td class="row_cell">
						<xsl:value-of select="@column"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dataelementceline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dataelementceline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:compositionceline_sourcelines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.EditionLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.editionline">
		<table>
			<xsl:if test="@jumptype != ''">
				<tr>
					<td class="row_cell">JumpType</td>
					<td class="row_cell">
						<xsl:value-of select="@jumptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@totalisationtype != ''">
				<tr>
					<td class="row_cell">TotalisationType</td>
					<td class="row_cell">
						<xsl:value-of select="@totalisationtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@functiontoperform != ''">
				<tr>
					<td class="row_cell">FunctionToPerform</td>
					<td class="row_cell">
						<xsl:value-of select="@functiontoperform"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@foreigntotalstructure != ''">
				<tr>
					<td class="row_cell">ForeignTotalStructure</td>
					<td class="row_cell">
						<xsl:value-of select="@foreigntotalstructure"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@jump != ''">
				<tr>
					<td class="row_cell">Jump</td>
					<td class="row_cell">
						<xsl:value-of select="@jump"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelid != ''">
				<tr>
					<td class="row_cell">LabelId</td>
					<td class="row_cell">
						<xsl:value-of select="@labelid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@structureid != ''">
				<tr>
					<td class="row_cell">StructureId</td>
					<td class="row_cell">
						<xsl:value-of select="@structureid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.LLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.lline">
		<table>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelid != ''">
				<tr>
					<td class="row_cell">LabelID</td>
					<td class="row_cell">
						<xsl:value-of select="@labelid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@jumptype != ''">
				<tr>
					<td class="row_cell">JumpType</td>
					<td class="row_cell">
						<xsl:value-of select="@jumptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fontcode != ''">
				<tr>
					<td class="row_cell">FontCode</td>
					<td class="row_cell">
						<xsl:value-of select="@fontcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.SourceLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.sourceline">
		<table>
			<xsl:if test="@continued != ''">
				<tr>
					<td class="row_cell">Continued</td>
					<td class="row_cell">
						<xsl:value-of select="@continued"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@operation != ''">
				<tr>
					<td class="row_cell">Operation</td>
					<td class="row_cell">
						<xsl:value-of select="@operation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@wsprefix != ''">
				<tr>
					<td class="row_cell">WSPrefix</td>
					<td class="row_cell">
						<xsl:value-of select="@wsprefix"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@source != ''">
				<tr>
					<td class="row_cell">Source</td>
					<td class="row_cell">
						<xsl:value-of select="@source"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@condition != ''">
				<tr>
					<td class="row_cell">Condition</td>
					<td class="row_cell">
						<xsl:value-of select="@condition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.report.UndefinedDataElementCELine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.report.undefineddataelementceline">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@format != ''">
				<tr>
					<td class="row_cell">Format</td>
					<td class="row_cell">
						<xsl:value-of select="@format"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@column != ''">
				<tr>
					<td class="row_cell">Column</td>
					<td class="row_cell">
						<xsl:value-of select="@column"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:compositionceline_sourcelines"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>