<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractBlockBase.xsl"></xsl:import>

	<!-- Template for the class: 'RelationalBlockBase' -->
	<xsl:template match="rpp:relationalblockbase">
		<h1 id="{@id}">
			RelationalBlockBase
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blocktype != ''">
				<tr>
					<td class="row_cell">BlockType</td>
					<td class="row_cell">
						<xsl:value-of select="@blocktype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@versionnumber != ''">
				<tr>
					<td class="row_cell">VersionNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@versionnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatefolder != ''">
				<tr>
					<td class="row_cell">GenerateFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@generatefolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateproject != ''">
				<tr>
					<td class="row_cell">GenerateProject</td>
					<td class="row_cell">
						<xsl:value-of select="@generateproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationoption != ''">
				<tr>
					<td class="row_cell">GenerationOption</td>
					<td class="row_cell">
						<xsl:value-of select="@generationoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractblockbase_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractblockbase_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:relationalblockbase_drlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'DRKLines' -->
	<xsl:template match="rpp:drline_drklines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DRKLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DRKLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.drkline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GCLines' -->
	<xsl:template match="rpp:drline_gclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:drline_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DRLines' -->
	<xsl:template match="rpp:relationalblockbase_drlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DRLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DRLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.drline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.blockbase.DRKLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.drkline">
		<table>
			<xsl:if test="@orderoractiontype != ''">
				<tr>
					<td class="row_cell">OrderOrActionType</td>
					<td class="row_cell">
						<xsl:value-of select="@orderoractiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:drkline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:drkline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.blockbase.DRLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.drline">
		<table>
			<xsl:if test="@sqlrecordtype != ''">
				<tr>
					<td class="row_cell">SQLRecordType</td>
					<td class="row_cell">
						<xsl:value-of select="@sqlrecordtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tableorviewcode != ''">
				<tr>
					<td class="row_cell">TableOrViewCode</td>
					<td class="row_cell">
						<xsl:value-of select="@tableorviewcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@keytype != ''">
				<tr>
					<td class="row_cell">KeyType</td>
					<td class="row_cell">
						<xsl:value-of select="@keytype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationtransactiontype != ''">
				<tr>
					<td class="row_cell">GenerationTransactionType</td>
					<td class="row_cell">
						<xsl:value-of select="@generationtransactiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:drline_referencedtable/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>ReferencedTable</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:drline_referencedtable/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:drline_drklines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:drline_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:drline_gclines"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>