<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="Publishing.xsl"></xsl:import>

	<!-- Template for the relation: 'Field' -->
	<xsl:template match="rpp:aggregatevalue_field">
		<p>
			<b>Field</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.field"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Field' -->
	<xsl:template match="rpp:descriptiontype_field">
		<p>
			<b>Field</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.field"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Value' -->
	<xsl:template match="rpp:field_value">
		<p>
			<b>Value</b>
		</p>
		<xsl:choose>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.AggregateValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.aggregatevalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ByteStringValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.bytestringvalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DateTimeValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datetimevalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DecimalValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.decimalvalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.FloatValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.floatvalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.IntegerValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.integervalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.MultipleValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.multiplevalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ReferenceValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referencevalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.StringValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.stringvalue"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.TimeStampValue'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.timestampvalue"></xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Template for the relation: 'Fields' -->
	<xsl:template match="rpp:aggregatevalue_fields">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Fields</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Field</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.field"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Values' -->
	<xsl:template match="rpp:multiplevalue_values">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Values</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.AggregateValue'">
							<b>AggregateValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.aggregatevalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ByteStringValue'">
							<b>ByteStringValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.bytestringvalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DateTimeValue'">
							<b>DateTimeValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datetimevalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DecimalValue'">
							<b>DecimalValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.decimalvalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.FloatValue'">
							<b>FloatValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.floatvalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.IntegerValue'">
							<b>IntegerValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.integervalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.MultipleValue'">
							<b>MultipleValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.multiplevalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ReferenceValue'">
							<b>ReferenceValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referencevalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.StringValue'">
							<b>StringValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.stringvalue"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.TimeStampValue'">
							<b>TimeStampValue</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.timestampvalue"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CalledEntities' -->
	<xsl:template match="rpp:radicalelement_calledentities">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CalledEntities</h3>
		</xsl:if>
		<ul>
			<li>
				<xsl:call-template name="rpp:artifact.link">
					<xsl:with-param name="idref" select="@idref"></xsl:with-param>
				</xsl:call-template>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CalledEntities2' -->
	<xsl:template match="rpp:radicalelement_calledentities2">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CalledEntities2</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CalledEntity</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.calledentity"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DescriptionTypes' -->
	<xsl:template match="rpp:radicalelement_descriptiontypes">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DescriptionTypes</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DescriptionType</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.descriptiontype"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Keywords' -->
	<xsl:template match="rpp:radicalelement_keywords">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Keywords</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Keyword</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.keyword"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.AggregateValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.aggregatevalue">

		<!--unary composition -->
		<xsl:apply-templates select="rpp:aggregatevalue_field"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:aggregatevalue_fields"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.ByteStringValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.bytestringvalue"></xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.CalledEntity' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.calledentity">
		<table>
			<xsl:if test="rpp:calledentity_entity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Entity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:calledentity_entity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DateTimeValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datetimevalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DecimalValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.decimalvalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DescriptionType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.descriptiontype">
		<table>
			<xsl:if test="rpp:descriptiontype_metaentitytype/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>MetaEntityType</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:descriptiontype_metaentitytype/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:descriptiontype_field"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Field' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.field">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:field_value"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.FloatValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.floatvalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.IntegerValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.integervalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Keyword' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.keyword">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.MultipleValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.multiplevalue">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:multiplevalue_values"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.ReferenceValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referencevalue">
		<table>
			<xsl:if test="rpp:referencevalue_value/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Value</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:referencevalue_value/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.StringValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.stringvalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.TimeStampValue' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.timestampvalue">
		<table>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>