<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">
	<xsl:output omit-xml-declaration="yes" />

	<xsl:param name="output.title"></xsl:param>
	<xsl:param name="output.css"></xsl:param>
	<xsl:param name="output.structure"></xsl:param>

	<!-- Publishing template -->
	<xsl:template match="rpp:publishing">
		<html>
			<head>
				<title>
					<xsl:value-of select="$output.title" />
				</title>
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"></meta>
				<xsl:choose>
					<xsl:when test="$output.css != ''">
						<link rel="stylesheet" href="{$output.css}" type="text/css"></link>
					</xsl:when>
					<xsl:otherwise>
						<link rel="stylesheet" href="rpp.css" type="text/css"></link>
					</xsl:otherwise>
				</xsl:choose>
			</head>
			<body>
				<xsl:apply-templates select="./*"></xsl:apply-templates>
			</body>
		</html>
	</xsl:template>

	<!-- Debug found templates <xsl:template match="node()"> found: <xsl:value-of select="name()"/> </xsl:template> -->

	<!-- Template for 'artifact.link' transformation -->
	<xsl:template name="rpp:artifact.link">
		<xsl:param name="idref"></xsl:param>
		<xsl:choose>
			<xsl:when test="$output.structure='folder'">
				<a hRef="../{$idref}.html#{$idref}">
					<xsl:value-of select="$idref"></xsl:value-of>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<a hRef="#{$idref}">
					<xsl:value-of select="$idref"></xsl:value-of>
				</a>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>