<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Program' -->
	<xsl:template match="rpp:program">
		<h1 id="{@id}">
			Program
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programid != ''">
				<tr>
					<td class="row_cell">ProgramId</td>
					<td class="row_cell">
						<xsl:value-of select="@programid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@variant != ''">
				<tr>
					<td class="row_cell">Variant</td>
					<td class="row_cell">
						<xsl:value-of select="@variant"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programstructure != ''">
				<tr>
					<td class="row_cell">ProgramStructure</td>
					<td class="row_cell">
						<xsl:value-of select="@programstructure"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presencevalidation != ''">
				<tr>
					<td class="row_cell">PresenceValidation</td>
					<td class="row_cell">
						<xsl:value-of select="@presencevalidation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sqlindicator != ''">
				<tr>
					<td class="row_cell">SQLIndicator</td>
					<td class="row_cell">
						<xsl:value-of select="@sqlindicator"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:program_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:program_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:program_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:program_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:program_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:program_cdlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'DataStructureCalls' -->
	<xsl:template match="rpp:cdlinedatastructure_datastructurecalls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DataStructureCalls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataStructureCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.datastructurecall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'ReportCalls' -->
	<xsl:template match="rpp:cdlinereport_reportcalls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ReportCalls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>ReportCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.reportcall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Parameters' -->
	<xsl:template match="rpp:cpline_parameters">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Parameters</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>MacroParameters</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'SegmentCalls' -->
	<xsl:template match="rpp:datastructurecall_segmentcalls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SegmentCalls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>SegmentCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.segmentcall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CDLines' -->
	<xsl:template match="rpp:program_cdlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CDLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.program.CDLineDataStructure'">
							<b>CDLineDataStructure</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cdlinedatastructure"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.program.CDLineReport'">
							<b>CDLineReport</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cdlinereport"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CPLines' -->
	<xsl:template match="rpp:program_cplines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CPLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CPLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:program_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GOLines' -->
	<xsl:template match="rpp:program_golines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GOLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.CDLineDataStructure' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cdlinedatastructure">
		<table>
			<xsl:if test="@breaklevel != ''">
				<tr>
					<td class="row_cell">BreakLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@breaklevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@filestatus != ''">
				<tr>
					<td class="row_cell">FileStatus</td>
					<td class="row_cell">
						<xsl:value-of select="@filestatus"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtypedataelementcode != ''">
				<tr>
					<td class="row_cell">RecordTypeDataElementCode</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtypedataelementcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@resultdatastructurecode != ''">
				<tr>
					<td class="row_cell">ResultDataStructureCode</td>
					<td class="row_cell">
						<xsl:value-of select="@resultdatastructurecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sortkeys != ''">
				<tr>
					<td class="row_cell">SortKeys</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkeys"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sourcedatastructurecode != ''">
				<tr>
					<td class="row_cell">SourceDataStructureCode</td>
					<td class="row_cell">
						<xsl:value-of select="@sourcedatastructurecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@synclevel != ''">
				<tr>
					<td class="row_cell">SyncLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@synclevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transactionbreaklevel != ''">
				<tr>
					<td class="row_cell">TransactionBreakLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@transactionbreaklevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accessmode != ''">
				<tr>
					<td class="row_cell">AccessMode</td>
					<td class="row_cell">
						<xsl:value-of select="@accessmode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@iomode != ''">
				<tr>
					<td class="row_cell">IOMode</td>
					<td class="row_cell">
						<xsl:value-of select="@iomode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@unittype != ''">
				<tr>
					<td class="row_cell">UnitType</td>
					<td class="row_cell">
						<xsl:value-of select="@unittype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@usage != ''">
				<tr>
					<td class="row_cell">Usage</td>
					<td class="row_cell">
						<xsl:value-of select="@usage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolrecordlevel != ''">
				<tr>
					<td class="row_cell">CobolRecordLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolrecordlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blockmode != ''">
				<tr>
					<td class="row_cell">BlockMode</td>
					<td class="row_cell">
						<xsl:value-of select="@blockmode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@formattype != ''">
				<tr>
					<td class="row_cell">FormatType</td>
					<td class="row_cell">
						<xsl:value-of select="@formattype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subscheme != ''">
				<tr>
					<td class="row_cell">SubScheme</td>
					<td class="row_cell">
						<xsl:value-of select="@subscheme"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateddescriptiontype != ''">
				<tr>
					<td class="row_cell">GeneratedDescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@generateddescriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@organization != ''">
				<tr>
					<td class="row_cell">Organization</td>
					<td class="row_cell">
						<xsl:value-of select="@organization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@physicalunittype != ''">
				<tr>
					<td class="row_cell">PhysicalUnitType</td>
					<td class="row_cell">
						<xsl:value-of select="@physicalunittype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@physicalunittypecomplement != ''">
				<tr>
					<td class="row_cell">PhysicalUnitTypeComplement</td>
					<td class="row_cell">
						<xsl:value-of select="@physicalunittypecomplement"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeydataelementcode != ''">
				<tr>
					<td class="row_cell">AccessKeyDataElementCode</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeydataelementcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@codeinprogram != ''">
				<tr>
					<td class="row_cell">CodeInProgram</td>
					<td class="row_cell">
						<xsl:value-of select="@codeinprogram"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blockfactor != ''">
				<tr>
					<td class="row_cell">BlockFactor</td>
					<td class="row_cell">
						<xsl:value-of select="@blockfactor"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blocktype != ''">
				<tr>
					<td class="row_cell">BlockType</td>
					<td class="row_cell">
						<xsl:value-of select="@blocktype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:cdlinedatastructure_datastructurecalls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.CDLineReport' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cdlinereport">
		<table>
			<xsl:if test="@accessmode != ''">
				<tr>
					<td class="row_cell">AccessMode</td>
					<td class="row_cell">
						<xsl:value-of select="@accessmode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@iomode != ''">
				<tr>
					<td class="row_cell">IOMode</td>
					<td class="row_cell">
						<xsl:value-of select="@iomode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@unittype != ''">
				<tr>
					<td class="row_cell">UnitType</td>
					<td class="row_cell">
						<xsl:value-of select="@unittype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@usage != ''">
				<tr>
					<td class="row_cell">Usage</td>
					<td class="row_cell">
						<xsl:value-of select="@usage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolrecordlevel != ''">
				<tr>
					<td class="row_cell">CobolRecordLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolrecordlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blockmode != ''">
				<tr>
					<td class="row_cell">BlockMode</td>
					<td class="row_cell">
						<xsl:value-of select="@blockmode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@formattype != ''">
				<tr>
					<td class="row_cell">FormatType</td>
					<td class="row_cell">
						<xsl:value-of select="@formattype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subscheme != ''">
				<tr>
					<td class="row_cell">SubScheme</td>
					<td class="row_cell">
						<xsl:value-of select="@subscheme"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateddescriptiontype != ''">
				<tr>
					<td class="row_cell">GeneratedDescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@generateddescriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@organization != ''">
				<tr>
					<td class="row_cell">Organization</td>
					<td class="row_cell">
						<xsl:value-of select="@organization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@physicalunittype != ''">
				<tr>
					<td class="row_cell">PhysicalUnitType</td>
					<td class="row_cell">
						<xsl:value-of select="@physicalunittype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@physicalunittypecomplement != ''">
				<tr>
					<td class="row_cell">PhysicalUnitTypeComplement</td>
					<td class="row_cell">
						<xsl:value-of select="@physicalunittypecomplement"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeydataelementcode != ''">
				<tr>
					<td class="row_cell">AccessKeyDataElementCode</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeydataelementcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@codeinprogram != ''">
				<tr>
					<td class="row_cell">CodeInProgram</td>
					<td class="row_cell">
						<xsl:value-of select="@codeinprogram"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blockfactor != ''">
				<tr>
					<td class="row_cell">BlockFactor</td>
					<td class="row_cell">
						<xsl:value-of select="@blockfactor"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blocktype != ''">
				<tr>
					<td class="row_cell">BlockType</td>
					<td class="row_cell">
						<xsl:value-of select="@blocktype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:cdlinereport_reportcalls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.CPLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline">
		<table>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:cpline_macro/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Macro</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:cpline_macro/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:cpline_parameters"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.DataStructureCall' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.datastructurecall">
		<table>
			<xsl:if test="@cobolposition != ''">
				<tr>
					<td class="row_cell">CobolPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:datastructurecall_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:datastructurecall_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:datastructurecall_segmentcalls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.MacroParameters' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters">
		<table>
			<xsl:if test="@id != ''">
				<tr>
					<td class="row_cell">Id</td>
					<td class="row_cell">
						<xsl:value-of select="@id"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:macroparameters_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.ReportCall' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.reportcall">
		<table>
			<xsl:if test="@suffixinfprogram != ''">
				<tr>
					<td class="row_cell">SuffixInfProgram</td>
					<td class="row_cell">
						<xsl:value-of select="@suffixinfprogram"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:reportcall_report/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Report</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:reportcall_report/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.SegmentCall' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.segmentcall">
		<table>
			<xsl:if test="@codeinprogram != ''">
				<tr>
					<td class="row_cell">CodeInProgram</td>
					<td class="row_cell">
						<xsl:value-of select="@codeinprogram"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolposition != ''">
				<tr>
					<td class="row_cell">CobolPosition</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolposition"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:segmentcall_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:segmentcall_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>