<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractSegment.xsl"></xsl:import>

	<!-- Template for the class: 'MonoStructureSegment' -->
	<xsl:template match="rpp:monostructuresegment">
		<h1 id="{@id}">
			MonoStructureSegment
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@creationcode != ''">
				<tr>
					<td class="row_cell">CreationCode</td>
					<td class="row_cell">
						<xsl:value-of select="@creationcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@modificationcode != ''">
				<tr>
					<td class="row_cell">ModificationCode</td>
					<td class="row_cell">
						<xsl:value-of select="@modificationcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@deletioncode != ''">
				<tr>
					<td class="row_cell">DeletionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@deletioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type4code != ''">
				<tr>
					<td class="row_cell">Type4Code</td>
					<td class="row_cell">
						<xsl:value-of select="@type4code"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type5code != ''">
				<tr>
					<td class="row_cell">Type5Code</td>
					<td class="row_cell">
						<xsl:value-of select="@type5code"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type6code != ''">
				<tr>
					<td class="row_cell">Type6Code</td>
					<td class="row_cell">
						<xsl:value-of select="@type6code"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@actioncode != ''">
				<tr>
					<td class="row_cell">ActionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@actioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@structurecode != ''">
				<tr>
					<td class="row_cell">StructureCode</td>
					<td class="row_cell">
						<xsl:value-of select="@structurecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tablesize != ''">
				<tr>
					<td class="row_cell">TableSize</td>
					<td class="row_cell">
						<xsl:value-of select="@tablesize"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurrencesnumber != ''">
				<tr>
					<td class="row_cell">OccurrencesNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@occurrencesnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractsegment_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractsegment_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractsegment_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:abstractsegment_statistics"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractsegment_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_celines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractsegment_leveladdresslength"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>