<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="DataDefinition.xsl"></xsl:import>

	<!-- Template for the class: 'MetaEntity' -->
	<xsl:template match="rpp:metaentity">
		<h1 id="{@id}">
			MetaEntity
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@userdocumentation != ''">
				<tr>
					<td class="row_cell">UserDocumentation</td>
					<td class="row_cell">
						<xsl:value-of select="@userdocumentation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:datadefinition_datadescription"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:metaentity_userentities"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:metaentity_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'GCLines' -->
	<xsl:template match="rpp:metaentity_gclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Line</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.line"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'UserEntities' -->
	<xsl:template match="rpp:metaentity_userentities">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>UserEntities</h3>
		</xsl:if>
		<ul>
			<li>
				<xsl:call-template name="rpp:artifact.link">
					<xsl:with-param name="idref" select="@idref"></xsl:with-param>
				</xsl:call-template>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Line' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.line">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:line_linkedentity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LinkedEntity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:line_linkedentity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>