<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Macro' -->
	<xsl:template match="rpp:macro">
		<h1 id="{@id}">
			Macro
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programid != ''">
				<tr>
					<td class="row_cell">ProgramId</td>
					<td class="row_cell">
						<xsl:value-of select="@programid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@mergepriority != ''">
				<tr>
					<td class="row_cell">MergePriority</td>
					<td class="row_cell">
						<xsl:value-of select="@mergepriority"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@source != ''">
				<tr>
					<td class="row_cell">Source</td>
					<td class="row_cell">
						<xsl:value-of select="@source"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:macro_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:macro_comments"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'Comments' -->
	<xsl:template match="rpp:macro_comments">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Comments</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CommentsParameters</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.macro.commentsparameters"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:macro_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.macro.CommentsParameters' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.macro.commentsparameters">
		<table>
			<xsl:if test="@commentline != ''">
				<tr>
					<td class="row_cell">CommentLine</td>
					<td class="row_cell">
						<xsl:value-of select="@commentline"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>