<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Library' -->
	<xsl:template match="rpp:library">
		<h1 id="{@id}">
			Library
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@alphanumericdelimiter != ''">
				<tr>
					<td class="row_cell">AlphanumericDelimiter</td>
					<td class="row_cell">
						<xsl:value-of select="@alphanumericdelimiter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateddateformat != ''">
				<tr>
					<td class="row_cell">GeneratedDateFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@generateddateformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlanguage != ''">
				<tr>
					<td class="row_cell">GeneratedLanguage</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlanguage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@decimalpointdelimiter != ''">
				<tr>
					<td class="row_cell">DecimalPointDelimiter</td>
					<td class="row_cell">
						<xsl:value-of select="@decimalpointdelimiter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@commentsinsertionoption != ''">
				<tr>
					<td class="row_cell">CommentsInsertionOption</td>
					<td class="row_cell">
						<xsl:value-of select="@commentsinsertionoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@centurysystemdate != ''">
				<tr>
					<td class="row_cell">CenturySystemDate</td>
					<td class="row_cell">
						<xsl:value-of select="@centurysystemdate"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@centuryreferenceyear != ''">
				<tr>
					<td class="row_cell">CenturyReferenceYear</td>
					<td class="row_cell">
						<xsl:value-of select="@centuryreferenceyear"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolformatting != ''">
				<tr>
					<td class="row_cell">CobolFormatting</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolformatting"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:library_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:library_generationprojects"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'GOLines' -->
	<xsl:template match="rpp:library_golines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GOLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GenerationProjects' -->
	<xsl:template match="rpp:library_generationprojects">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GenerationProjects</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>GenerationProject</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.library.generationproject"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.library.GenerationProject' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.library.generationproject">
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@pattern != ''">
				<tr>
					<td class="row_cell">Pattern</td>
					<td class="row_cell">
						<xsl:value-of select="@pattern"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designtype != ''">
				<tr>
					<td class="row_cell">DesignType</td>
					<td class="row_cell">
						<xsl:value-of select="@designtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@rank != ''">
				<tr>
					<td class="row_cell">Rank</td>
					<td class="row_cell">
						<xsl:value-of select="@rank"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@folder != ''">
				<tr>
					<td class="row_cell">Folder</td>
					<td class="row_cell">
						<xsl:value-of select="@folder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>