<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'InputAid' -->
	<xsl:template match="rpp:inputaid">
		<h1 id="{@id}">
			InputAid
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:inputaid_symbolicvaluelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:inputaid_descriptionlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'DescriptionLines' -->
	<xsl:template match="rpp:inputaid_descriptionlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DescriptionLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>InputAidDescriptionLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.inputaid.inputaiddescriptionline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'SymbolicValueLines' -->
	<xsl:template match="rpp:inputaid_symbolicvaluelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SymbolicValueLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>InputAidSymbolicValueLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.inputaid.inputaidsymbolicvalueline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.inputaid.InputAidDescriptionLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.inputaid.inputaiddescriptionline">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@fixedlabel != ''">
				<tr>
					<td class="row_cell">FixedLabel</td>
					<td class="row_cell">
						<xsl:value-of select="@fixedlabel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@variablelabel != ''">
				<tr>
					<td class="row_cell">VariableLabel</td>
					<td class="row_cell">
						<xsl:value-of select="@variablelabel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@length != ''">
				<tr>
					<td class="row_cell">Length</td>
					<td class="row_cell">
						<xsl:value-of select="@length"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@calltypeline != ''">
				<tr>
					<td class="row_cell">CallTypeLine</td>
					<td class="row_cell">
						<xsl:value-of select="@calltypeline"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@xrefkey != ''">
				<tr>
					<td class="row_cell">XrefKey</td>
					<td class="row_cell">
						<xsl:value-of select="@xrefkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@symbolicparameter != ''">
				<tr>
					<td class="row_cell">SymbolicParameter</td>
					<td class="row_cell">
						<xsl:value-of select="@symbolicparameter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.inputaid.InputAidSymbolicValueLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.inputaid.inputaidsymbolicvalueline">
		<table>
			<xsl:if test="@parameter != ''">
				<tr>
					<td class="row_cell">Parameter</td>
					<td class="row_cell">
						<xsl:value-of select="@parameter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>