<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractDialogFolder.xsl"></xsl:import>

	<!-- Template for the class: 'Folder' -->
	<xsl:template match="rpp:folder">
		<h1 id="{@id}">
			Folder
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@lockoption != ''">
				<tr>
					<td class="row_cell">LockOption</td>
					<td class="row_cell">
						<xsl:value-of select="@lockoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@paginationmode != ''">
				<tr>
					<td class="row_cell">PaginationMode</td>
					<td class="row_cell">
						<xsl:value-of select="@paginationmode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@destinationproject != ''">
				<tr>
					<td class="row_cell">DestinationProject</td>
					<td class="row_cell">
						<xsl:value-of select="@destinationproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@destinationfolder != ''">
				<tr>
					<td class="row_cell">DestinationFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@destinationfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:folder_dialogfolder/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DialogFolder</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:folder_dialogfolder/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractdialogfolder_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractdialogfolder_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractdialogfolder_errorserver/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>ErrorServer</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractdialogfolder_errorserver/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:folder_rootnode"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractdialogfolder_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogfolder_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'RootNode' -->
	<xsl:template match="rpp:folder_rootnode">
		<p>
			<b>RootNode</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.rootnode"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'ChildNodes' -->
	<xsl:template match="rpp:childnode_childnodes">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ChildNodes</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>ChildNode</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.childnode"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DisplayKeys' -->
	<xsl:template match="rpp:childnode_displaykeys">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DisplayKeys</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>NodeDisplayKey</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.nodedisplaykey"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'ChildNodes' -->
	<xsl:template match="rpp:rootnode_childnodes">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ChildNodes</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>ChildNode</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.childnode"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dialogfolder.ChildNode' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.childnode">
		<table>
			<xsl:if test="@typenode != ''">
				<tr>
					<td class="row_cell">TypeNode</td>
					<td class="row_cell">
						<xsl:value-of select="@typenode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema != ''">
				<tr>
					<td class="row_cell">SubSchema</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cardinality != ''">
				<tr>
					<td class="row_cell">Cardinality</td>
					<td class="row_cell">
						<xsl:value-of select="@cardinality"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nodecode != ''">
				<tr>
					<td class="row_cell">NodeCode</td>
					<td class="row_cell">
						<xsl:value-of select="@nodecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractnode_logicalview/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LogicalView</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractnode_logicalview/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractnode_server/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Server</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractnode_server/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:childnode_displaykeys"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:childnode_childnodes"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dialogfolder.NodeDisplayKey' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.nodedisplaykey">
		<table>
			<xsl:if test="rpp:nodedisplaykey_dataelementkey/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElementKey</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:nodedisplaykey_dataelementkey/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:nodedisplaykey_dataelementsource/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElementSource</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:nodedisplaykey_dataelementsource/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dialogfolder.RootNode' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialogfolder.rootnode">
		<table>
			<xsl:if test="@nodecode != ''">
				<tr>
					<td class="row_cell">NodeCode</td>
					<td class="row_cell">
						<xsl:value-of select="@nodecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractnode_logicalview/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LogicalView</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractnode_logicalview/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractnode_server/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Server</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractnode_server/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:rootnode_childnodes"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>