<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'ErrorLabel' -->
	<xsl:template match="rpp:errorlabel">
		<h1 id="{@id}">
			ErrorLabel
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationtype != ''">
				<tr>
					<td class="row_cell">GenerationType</td>
					<td class="row_cell">
						<xsl:value-of select="@generationtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@desinationfolder != ''">
				<tr>
					<td class="row_cell">DesinationFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@desinationfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@destinationproject != ''">
				<tr>
					<td class="row_cell">DestinationProject</td>
					<td class="row_cell">
						<xsl:value-of select="@destinationproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlanguage != ''">
				<tr>
					<td class="row_cell">GeneratedLanguage</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlanguage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationoption != ''">
				<tr>
					<td class="row_cell">GenerationOption</td>
					<td class="row_cell">
						<xsl:value-of select="@generationoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:errorlabel_generationlibray/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibray</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:errorlabel_generationlibray/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:errorlabel_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:errorlabel_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:errorlabel_dialog/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Dialog</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:errorlabel_dialog/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:errorlabel_dialogserver/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DialogServer</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:errorlabel_dialogserver/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:errorlabel_entitiesselected"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'EntitiesSelected' -->
	<xsl:template match="rpp:errorlabel_entitiesselected">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>EntitiesSelected</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>ErrorLabelEntitiesSelected</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.errorlabel.errorlabelentitiesselected"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.errorlabel.ErrorLabelEntitiesSelected' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.errorlabel.errorlabelentitiesselected">
		<table>
			<xsl:if test="rpp:errorlabelentitiesselected_radicalelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>RadicalElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:errorlabelentitiesselected_radicalelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>