<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractDialogCommunicationMonitor.xsl"></xsl:import>

	<!-- Template for the class: 'DialogCommunicationMonitor' -->
	<xsl:template match="rpp:dialogcommunicationmonitor">
		<h1 id="{@id}">
			DialogCommunicationMonitor
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@messagesize != ''">
				<tr>
					<td class="row_cell">MessageSize</td>
					<td class="row_cell">
						<xsl:value-of select="@messagesize"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagesent != ''">
				<tr>
					<td class="row_cell">ErrorMessageSent</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagesent"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@communicationtype != ''">
				<tr>
					<td class="row_cell">CommunicationType</td>
					<td class="row_cell">
						<xsl:value-of select="@communicationtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transactioncode != ''">
				<tr>
					<td class="row_cell">TransactionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@transactioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractdialogcommunicationmonitor_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref"
								select="rpp:abstractdialogcommunicationmonitor_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractdialogcommunicationmonitor_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialogcommunicationmonitor_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>