<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractDialog.xsl"></xsl:import>

	<!-- Template for the class: 'Dialog' -->
	<xsl:template match="rpp:dialog">
		<h1 id="{@id}">
			Dialog
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@firstscreencode != ''">
				<tr>
					<td class="row_cell">FirstScreenCode</td>
					<td class="row_cell">
						<xsl:value-of select="@firstscreencode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@options != ''">
				<tr>
					<td class="row_cell">Options</td>
					<td class="row_cell">
						<xsl:value-of select="@options"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagefileorganization != ''">
				<tr>
					<td class="row_cell">ErrorMessageFileOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagefileorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagefileexternalname != ''">
				<tr>
					<td class="row_cell">ErrorMessageFileExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagefileexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@complementcommonarealength != ''">
				<tr>
					<td class="row_cell">ComplementCommonAreaLength</td>
					<td class="row_cell">
						<xsl:value-of select="@complementcommonarealength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagefileorganizationclient != ''">
				<tr>
					<td class="row_cell">ErrorMessageFileOrganizationClient</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagefileorganizationclient"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@dialogtype != ''">
				<tr>
					<td class="row_cell">DialogType</td>
					<td class="row_cell">
						<xsl:value-of select="@dialogtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@programexternalname != ''">
				<tr>
					<td class="row_cell">ProgramExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@programexternalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maptype != ''">
				<tr>
					<td class="row_cell">MapType</td>
					<td class="row_cell">
						<xsl:value-of select="@maptype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transactioncode != ''">
				<tr>
					<td class="row_cell">TransactionCode</td>
					<td class="row_cell">
						<xsl:value-of select="@transactioncode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenlinenumber != ''">
				<tr>
					<td class="row_cell">ScreenLineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@screenlinenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screencolumnnumber != ''">
				<tr>
					<td class="row_cell">ScreenColumnNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@screencolumnnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@tabs != ''">
				<tr>
					<td class="row_cell">Tabs</td>
					<td class="row_cell">
						<xsl:value-of select="@tabs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentation != ''">
				<tr>
					<td class="row_cell">LabelPresentation</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@initialcharacter != ''">
				<tr>
					<td class="row_cell">InitialCharacter</td>
					<td class="row_cell">
						<xsl:value-of select="@initialcharacter"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@helpcharacterscreen != ''">
				<tr>
					<td class="row_cell">HelpCharacterScreen</td>
					<td class="row_cell">
						<xsl:value-of select="@helpcharacterscreen"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@helpcharacterelement != ''">
				<tr>
					<td class="row_cell">HelpCharacterElement</td>
					<td class="row_cell">
						<xsl:value-of select="@helpcharacterelement"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelintensityattribute != ''">
				<tr>
					<td class="row_cell">LabelIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelcolorattribute != ''">
				<tr>
					<td class="row_cell">LabelColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@labelpresentationattribute != ''">
				<tr>
					<td class="row_cell">LabelPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@labelpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputintensityattribute != ''">
				<tr>
					<td class="row_cell">InputIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputcolorattribute != ''">
				<tr>
					<td class="row_cell">InputColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputpresentationattribute != ''">
				<tr>
					<td class="row_cell">InputPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@inputpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayintensityattribute != ''">
				<tr>
					<td class="row_cell">DisplayIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displayintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displaycolorattribute != ''">
				<tr>
					<td class="row_cell">DisplayColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displaycolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displaypresentationattribute != ''">
				<tr>
					<td class="row_cell">DisplayPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@displaypresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessageintensityattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessageIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessageintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagecolorattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessageColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagecolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errormessagepresentationattribute != ''">
				<tr>
					<td class="row_cell">ErrorMessagePresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errormessagepresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldintensityattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldIntensityAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldintensityattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldcolorattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldColorAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldcolorattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@errorfieldpresentationattribute != ''">
				<tr>
					<td class="row_cell">ErrorFieldPresentationAttribute</td>
					<td class="row_cell">
						<xsl:value-of select="@errorfieldpresentationattribute"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@mapfolder != ''">
				<tr>
					<td class="row_cell">MapFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@mapfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@mapproject != ''">
				<tr>
					<td class="row_cell">MapProject</td>
					<td class="row_cell">
						<xsl:value-of select="@mapproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dialog_psborsubschemacode/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>PsbOrSubSchemaCode</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dialog_psborsubschemacode/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dialog_commonarea/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>CommonArea</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dialog_commonarea/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractdialog_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractdialog_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dialog_monitors"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_cplines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractdialog_cslines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'ScreensCalled' -->
	<xsl:template match="rpp:dialogmonitor_screenscalled">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ScreensCalled</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>ScreenCalledMonitor</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialog.screencalledmonitor"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Monitors' -->
	<xsl:template match="rpp:dialog_monitors">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Monitors</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DialogMonitor</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialog.dialogmonitor"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dialog.DialogMonitor' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialog.dialogmonitor">
		<table>
			<xsl:if test="rpp:dialogmonitor_monitor/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Monitor</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dialogmonitor_monitor/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dialogmonitor_screenscalled"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dialog.ScreenCalledMonitor' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dialog.screencalledmonitor">
		<table>
			<xsl:if test="@calltype != ''">
				<tr>
					<td class="row_cell">CallType</td>
					<td class="row_cell">
						<xsl:value-of select="@calltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:screencalledmonitor_screen/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Screen</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:screencalledmonitor_screen/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>