<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'DataStructure' -->
	<xsl:template match="rpp:datastructure">
		<h1 id="{@id}">
			DataStructure
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comments != ''">
				<tr>
					<td class="row_cell">Comments</td>
					<td class="row_cell">
						<xsl:value-of select="@comments"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:datastructure_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:datastructure_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:datastructure_lslines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:datastructure_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:datastructure_lslines2"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:datastructure_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'LSLines' -->
	<xsl:template match="rpp:datastructure_lslines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>LSLines</h3>
		</xsl:if>
		<ul>
			<li>
				<xsl:call-template name="rpp:artifact.link">
					<xsl:with-param name="idref" select="@idref"></xsl:with-param>
				</xsl:call-template>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'LSLines2' -->
	<xsl:template match="rpp:datastructure_lslines2">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>LSLines2</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>LSLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.datastructure.lsline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.datastructure.LSLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.datastructure.lsline">
		<table>
			<xsl:if test="rpp:lsline_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:lsline_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>