<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="DataDefinition.xsl"></xsl:import>

	<!-- Template for the class: 'DataElement' -->
	<xsl:template match="rpp:dataelement">
		<h1 id="{@id}">
			DataElement
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internalformat != ''">
				<tr>
					<td class="row_cell">InternalFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@internalformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internalusage != ''">
				<tr>
					<td class="row_cell">InternalUsage</td>
					<td class="row_cell">
						<xsl:value-of select="@internalusage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputformat != ''">
				<tr>
					<td class="row_cell">InputFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@inputformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@outputformat != ''">
				<tr>
					<td class="row_cell">OutputFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@outputformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blankwhenzero != ''">
				<tr>
					<td class="row_cell">BlankWhenZero</td>
					<td class="row_cell">
						<xsl:value-of select="@blankwhenzero"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internallength != ''">
				<tr>
					<td class="row_cell">InternalLength</td>
					<td class="row_cell">
						<xsl:value-of select="@internallength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputlength != ''">
				<tr>
					<td class="row_cell">InputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@inputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@outputlength != ''">
				<tr>
					<td class="row_cell">OutputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@outputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dataelement_parent/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Parent</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dataelement_parent/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dataelement_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dataelement_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:datadefinition_datadescription"></xsl:apply-templates>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:dataelement_childrendataelements"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dataelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:dataelement_dlines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:dataelement_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'ChildrenDataElements' -->
	<xsl:template match="rpp:dataelement_childrendataelements">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ChildrenDataElements</h3>
		</xsl:if>
		<ul>
			<li>
				<xsl:call-template name="rpp:artifact.link">
					<xsl:with-param name="idref" select="@idref"></xsl:with-param>
				</xsl:call-template>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'DLines' -->
	<xsl:template match="rpp:dataelement_dlines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataElementDescription</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dataelement.dataelementdescription"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GCLines' -->
	<xsl:template match="rpp:dataelement_gclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:dataelement_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Data' -->
	<xsl:template match="rpp:inputaidgline_data">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Data</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:value-of select="."></xsl:value-of>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.dataelement.DataElementDescription' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.dataelement.dataelementdescription">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@more != ''">
				<tr>
					<td class="row_cell">More</td>
					<td class="row_cell">
						<xsl:value-of select="@more"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@allowedvalues != ''">
				<tr>
					<td class="row_cell">AllowedValues</td>
					<td class="row_cell">
						<xsl:value-of select="@allowedvalues"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.GLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:line_linkedentity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LinkedEntity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:line_linkedentity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.InputAidGLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:inputaidgline_inputaid/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>InputAid</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:inputaidgline_inputaid/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:line_linkedentity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LinkedEntity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:line_linkedentity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:inputaidgline_data"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>