<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="RadicalElement.xsl"></xsl:import>

	<!-- Template for the relation: 'DataDescription' -->
	<xsl:template match="rpp:datacall_datadescription">
		<p>
			<b>DataDescription</b>
		</p>
		<xsl:choose>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DataAggregateDescription'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataaggregatedescription"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DataElementDescription'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataelementdescription"></xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Template for the relation: 'Identifier' -->
	<xsl:template match="rpp:datacall_identifier">
		<p>
			<b>Identifier</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.identifier"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Sort' -->
	<xsl:template match="rpp:datacall_sort">
		<p>
			<b>Sort</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.sort"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Unique' -->
	<xsl:template match="rpp:datacall_unique">
		<p>
			<b>Unique</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.unique"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'DataDescription' -->
	<xsl:template match="rpp:datadefinition_datadescription">
		<p>
			<b>DataDescription</b>
		</p>
		<xsl:choose>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DataAggregateDescription'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataaggregatedescription"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DataElementDescription'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataelementdescription"></xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Template for the relation: 'InitialValue' -->
	<xsl:template match="rpp:dataelementdescription_initialvalue">
		<p>
			<b>InitialValue</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.value"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Type' -->
	<xsl:template match="rpp:dataelementdescription_type">
		<p>
			<b>Type</b>
		</p>
		<xsl:choose>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ByteStringType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.bytestringtype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DateTimeType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datetimetype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.DecimalType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.decimaltype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.FloatType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.floattype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.IntegerType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.integertype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ReferenceType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referencetype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.StringType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.stringtype"></xsl:call-template>
			</xsl:when>
			<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.TimeStampType'">
				<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.timestamptype"></xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Template for the relation: 'MaxValue' -->
	<xsl:template match="rpp:interval_maxvalue">
		<p>
			<b>MaxValue</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.value"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'MinValue' -->
	<xsl:template match="rpp:interval_minvalue">
		<p>
			<b>MinValue</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.value"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'Components' -->
	<xsl:template match="rpp:dataaggregatedescription_components">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Components</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datacall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'AllowedIntervals' -->
	<xsl:template match="rpp:dataelementdescription_allowedintervals">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>AllowedIntervals</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Interval</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.interval"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'AllowedValues' -->
	<xsl:template match="rpp:dataelementdescription_allowedvalues">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>AllowedValues</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>Value</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.value"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Calls' -->
	<xsl:template match="rpp:identifier_calls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Calls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datacall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'ReferenceConstraints' -->
	<xsl:template match="rpp:referencetype_referenceconstraints">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>ReferenceConstraints</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.ReferenceConstraint'">
							<b>ReferenceConstraint</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referenceconstraint"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.kernel.UserEntityReferenceConstraint'">
							<b>UserEntityReferenceConstraint</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.userentityreferenceconstraint"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Calls' -->
	<xsl:template match="rpp:sort_calls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Calls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datacall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Calls' -->
	<xsl:template match="rpp:unique_calls">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Calls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DataCall</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datacall"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'MetaEntityTypeNames' -->
	<xsl:template match="rpp:userentityreferenceconstraint_metaentitytypenames">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>MetaEntityTypeNames</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:value-of select="."></xsl:value-of>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.ByteStringType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.bytestringtype">
		<table>
			<xsl:if test="@maxlength != ''">
				<tr>
					<td class="row_cell">MaxLength</td>
					<td class="row_cell">
						<xsl:value-of select="@maxlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DataAggregateDescription' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataaggregatedescription">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dataaggregatedescription_components"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DataCall' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datacall">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@minimumcardinality != ''">
				<tr>
					<td class="row_cell">MinimumCardinality</td>
					<td class="row_cell">
						<xsl:value-of select="@minimumcardinality"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maximumcardinality != ''">
				<tr>
					<td class="row_cell">MaximumCardinality</td>
					<td class="row_cell">
						<xsl:value-of select="@maximumcardinality"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:datacall_datadefinition/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataDefinition</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:datacall_datadefinition/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:datacall_datadescription"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:datacall_unique"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:datacall_sort"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:datacall_identifier"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DataElementDescription' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.dataelementdescription">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:dataelementdescription_type"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:dataelementdescription_initialvalue"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dataelementdescription_allowedintervals"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:dataelementdescription_allowedvalues"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DateTimeType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.datetimetype">
		<table>
			<xsl:if test="@format != ''">
				<tr>
					<td class="row_cell">Format</td>
					<td class="row_cell">
						<xsl:value-of select="@format"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.DecimalType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.decimaltype">
		<table>
			<xsl:if test="@minvalue != ''">
				<tr>
					<td class="row_cell">MinValue</td>
					<td class="row_cell">
						<xsl:value-of select="@minvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maxvalue != ''">
				<tr>
					<td class="row_cell">MaxValue</td>
					<td class="row_cell">
						<xsl:value-of select="@maxvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.FloatType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.floattype">
		<table>
			<xsl:if test="@capacity != ''">
				<tr>
					<td class="row_cell">Capacity</td>
					<td class="row_cell">
						<xsl:value-of select="@capacity"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Identifier' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.identifier">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:identifier_calls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.IntegerType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.integertype">
		<table>
			<xsl:if test="@minvalue != ''">
				<tr>
					<td class="row_cell">MinValue</td>
					<td class="row_cell">
						<xsl:value-of select="@minvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maxvalue != ''">
				<tr>
					<td class="row_cell">MaxValue</td>
					<td class="row_cell">
						<xsl:value-of select="@maxvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Interval' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.interval">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:interval_maxvalue"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:interval_minvalue"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.ReferenceConstraint' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referenceconstraint">
		<table>
			<xsl:if test="@referencetypename != ''">
				<tr>
					<td class="row_cell">ReferenceTypeName</td>
					<td class="row_cell">
						<xsl:value-of select="@referencetypename"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.ReferenceType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.referencetype">
		<table>
			<xsl:if test="@maxlength != ''">
				<tr>
					<td class="row_cell">MaxLength</td>
					<td class="row_cell">
						<xsl:value-of select="@maxlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@case != ''">
				<tr>
					<td class="row_cell">Case</td>
					<td class="row_cell">
						<xsl:value-of select="@case"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:referencetype_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:referencetype_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:referencetype_referenceconstraints"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Sort' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.sort">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:sort_calls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.StringType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.stringtype">
		<table>
			<xsl:if test="@maxlength != ''">
				<tr>
					<td class="row_cell">MaxLength</td>
					<td class="row_cell">
						<xsl:value-of select="@maxlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@case != ''">
				<tr>
					<td class="row_cell">Case</td>
					<td class="row_cell">
						<xsl:value-of select="@case"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.TimeStampType' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.timestamptype">
		<table>
			<xsl:if test="@minvalue != ''">
				<tr>
					<td class="row_cell">MinValue</td>
					<td class="row_cell">
						<xsl:value-of select="@minvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@maxvalue != ''">
				<tr>
					<td class="row_cell">MaxValue</td>
					<td class="row_cell">
						<xsl:value-of select="@maxvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Unique' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.unique">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:unique_calls"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.UserEntityReferenceConstraint' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.userentityreferenceconstraint">
		<table>
			<xsl:if test="@referencetypename != ''">
				<tr>
					<td class="row_cell">ReferenceTypeName</td>
					<td class="row_cell">
						<xsl:value-of select="@referencetypename"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:userentityreferenceconstraint_metaentitytypenames"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.kernel.Value' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.kernel.value">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>