<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the class: 'Copybook' -->
	<xsl:template match="rpp:copybook">
		<h1 id="{@id}">
			Copybook
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolproject != ''">
				<tr>
					<td class="row_cell">CobolProject</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobolfolder != ''">
				<tr>
					<td class="row_cell">CobolFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@cobolfolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationtype != ''">
				<tr>
					<td class="row_cell">GenerationType</td>
					<td class="row_cell">
						<xsl:value-of select="@generationtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@dscodetype != ''">
				<tr>
					<td class="row_cell">DSCodeType</td>
					<td class="row_cell">
						<xsl:value-of select="@dscodetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@cobollocationcode != ''">
				<tr>
					<td class="row_cell">CobolLocationCode</td>
					<td class="row_cell">
						<xsl:value-of select="@cobollocationcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@coboltype != ''">
				<tr>
					<td class="row_cell">CobolType</td>
					<td class="row_cell">
						<xsl:value-of select="@coboltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@formattype != ''">
				<tr>
					<td class="row_cell">FormatType</td>
					<td class="row_cell">
						<xsl:value-of select="@formattype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtype != ''">
				<tr>
					<td class="row_cell">RecordType</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordlevel != ''">
				<tr>
					<td class="row_cell">RecordLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@recordlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presindicator != ''">
				<tr>
					<td class="row_cell">PresIndicator</td>
					<td class="row_cell">
						<xsl:value-of select="@presindicator"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@datastructurecode != ''">
				<tr>
					<td class="row_cell">DataStructureCode</td>
					<td class="row_cell">
						<xsl:value-of select="@datastructurecode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:copybook_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:copybook_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:copybook_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:copybook_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:copybook_blockbase/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>BlockBase</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:copybook_blockbase/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:copybook_entitiesselected"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'EntitiesSelected' -->
	<xsl:template match="rpp:copybook_entitiesselected">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>EntitiesSelected</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CopybookEntitiesSelected</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.copybook.copybookentitiesselected"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.copybook.CopybookEntitiesSelected' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.copybook.copybookentitiesselected">
		<table>
			<xsl:if test="rpp:copybookentitiesselected_dataaggregate/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataAggregate</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:copybookentitiesselected_dataaggregate/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>