<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractBlockBase.xsl"></xsl:import>

	<!-- Template for the class: 'CodasylBlockBase' -->
	<xsl:template match="rpp:codasylblockbase">
		<h1 id="{@id}">
			CodasylBlockBase
			<xsl:value-of select="@name"></xsl:value-of>
		</h1>
		<table>
			<xsl:if test="@project != ''">
				<tr>
					<td class="row_cell">Project</td>
					<td class="row_cell">
						<xsl:value-of select="@project"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@schemanumber != ''">
				<tr>
					<td class="row_cell">SchemaNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@schemanumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@blocktype != ''">
				<tr>
					<td class="row_cell">BlockType</td>
					<td class="row_cell">
						<xsl:value-of select="@blocktype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@versionnumber != ''">
				<tr>
					<td class="row_cell">VersionNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@versionnumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@type != ''">
				<tr>
					<td class="row_cell">Type</td>
					<td class="row_cell">
						<xsl:value-of select="@type"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatefolder != ''">
				<tr>
					<td class="row_cell">GenerateFolder</td>
					<td class="row_cell">
						<xsl:value-of select="@generatefolder"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generateproject != ''">
				<tr>
					<td class="row_cell">GenerateProject</td>
					<td class="row_cell">
						<xsl:value-of select="@generateproject"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationoption != ''">
				<tr>
					<td class="row_cell">GenerationOption</td>
					<td class="row_cell">
						<xsl:value-of select="@generationoption"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@designid != ''">
				<tr>
					<td class="row_cell">DesignId</td>
					<td class="row_cell">
						<xsl:value-of select="@designid"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@entityversion != ''">
				<tr>
					<td class="row_cell">EntityVersion</td>
					<td class="row_cell">
						<xsl:value-of select="@entityversion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractblockbase_generationlibrary/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>GenerationLibrary</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractblockbase_generationlibrary/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple aggregation -->
		<xsl:apply-templates select="rpp:radicalelement_calledentities"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:codasylblockbase_dclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_golines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractblockbase_gglines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractradicalelement_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_keywords"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_descriptiontypes"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:radicalelement_calledentities2"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the relation: 'DCLines' -->
	<xsl:template match="rpp:codasylblockbase_dclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>DCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>DCLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.dcline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:dcline_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.blockbase.DCLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.blockbase.dcline">
		<table>
			<xsl:if test="@networkrecordtype != ''">
				<tr>
					<td class="row_cell">NetworkRecordType</td>
					<td class="row_cell">
						<xsl:value-of select="@networkrecordtype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@databaseobjectname != ''">
				<tr>
					<td class="row_cell">DatabaseObjectName</td>
					<td class="row_cell">
						<xsl:value-of select="@databaseobjectname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@methodname != ''">
				<tr>
					<td class="row_cell">MethodName</td>
					<td class="row_cell">
						<xsl:value-of select="@methodname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@numberofoccurencesofsets != ''">
				<tr>
					<td class="row_cell">NumberOfOccurencesOfSets</td>
					<td class="row_cell">
						<xsl:value-of select="@numberofoccurencesofsets"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@areanameorsetnameorcomment != ''">
				<tr>
					<td class="row_cell">AreaNameOrSetNameOrComment</td>
					<td class="row_cell">
						<xsl:value-of select="@areanameorsetnameorcomment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dcline_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dcline_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dcline_childsegment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>ChildSegment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dcline_childsegment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:dcline_fromsegment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>FromSegment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dcline_fromsegment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:dcline_gglines"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>