<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the relation: 'Statistics' -->
	<xsl:template match="rpp:abstractsegment_statistics">
		<p>
			<b>Statistics</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.statistics"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'DBE' -->
	<xsl:template match="rpp:component_dbe">
		<p>
			<b>DBE</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.sqlcomplement"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'PresenceCheck' -->
	<xsl:template match="rpp:component_presencecheck">
		<p>
			<b>PresenceCheck</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.presencecheck"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'SE' -->
	<xsl:template match="rpp:component_se">
		<p>
			<b>SE</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.socrateelement"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'PresenceCheck' -->
	<xsl:template match="rpp:filler_presencecheck">
		<p>
			<b>PresenceCheck</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.presencecheck"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'SubSchemaAssignment' -->
	<xsl:template match="rpp:logicalviewcomponent_subschemaassignment">
		<p>
			<b>SubSchemaAssignment</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.subschemaassignment"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'UndefinedDataElementColumn' -->
	<xsl:template match="rpp:sqlcomplement_undefineddataelementcolumn">
		<p>
			<b>UndefinedDataElementColumn</b>
		</p>
		<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent"></xsl:call-template>
	</xsl:template>

	<!-- Template for the relation: 'GCLines' -->
	<xsl:template match="rpp:abstractceline_gclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:abstractceline_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:abstractceline_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'MoreControls' -->
	<xsl:template match="rpp:abstractceline_morecontrols">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>MoreControls</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>MoreControls</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.morecontrols"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CELines' -->
	<xsl:template match="rpp:abstractsegment_celines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Component'">
							<b>Component</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.component"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent'">
							<b>DataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.dataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Filler'">
							<b>Filler</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.filler"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.GroupComponent'">
							<b>GroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.groupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent'">
							<b>LVDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvdataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent'">
							<b>LVGroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvgroupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent'">
							<b>LVSegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvsegmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup'">
							<b>RedefinesGroup</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.redefinesgroup"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent'">
							<b>SegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.segmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent'">
							<b>UndefinedDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:abstractsegment_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:abstractsegment_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GOLines' -->
	<xsl:template match="rpp:abstractsegment_golines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GOLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'LevelAddressLength' -->
	<xsl:template match="rpp:abstractsegment_leveladdresslength">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>LevelAddressLength</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>LevelAddressLength</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.leveladdresslength"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CompositionGroup' -->
	<xsl:template match="rpp:groupcomponent_compositiongroup">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CompositionGroup</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Component'">
							<b>Component</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.component"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent'">
							<b>DataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.dataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Filler'">
							<b>Filler</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.filler"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.GroupComponent'">
							<b>GroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.groupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent'">
							<b>LVDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvdataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent'">
							<b>LVGroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvgroupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent'">
							<b>LVSegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvsegmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup'">
							<b>RedefinesGroup</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.redefinesgroup"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent'">
							<b>SegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.segmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent'">
							<b>UndefinedDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CompositionGroup' -->
	<xsl:template match="rpp:lvgroupcomponent_compositiongroup">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CompositionGroup</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Component'">
							<b>Component</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.component"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent'">
							<b>DataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.dataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Filler'">
							<b>Filler</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.filler"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.GroupComponent'">
							<b>GroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.groupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent'">
							<b>LVDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvdataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent'">
							<b>LVGroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvgroupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent'">
							<b>LVSegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvsegmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup'">
							<b>RedefinesGroup</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.redefinesgroup"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent'">
							<b>SegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.segmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent'">
							<b>UndefinedDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'SetOfRedefines' -->
	<xsl:template match="rpp:redefinesgroup_setofredefines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>SetOfRedefines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Component'">
							<b>Component</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.component"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent'">
							<b>DataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.dataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.Filler'">
							<b>Filler</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.filler"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.GroupComponent'">
							<b>GroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.groupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent'">
							<b>LVDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvdataelementcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent'">
							<b>LVGroupComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvgroupcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent'">
							<b>LVSegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvsegmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup'">
							<b>RedefinesGroup</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.redefinesgroup"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent'">
							<b>SegmentComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.segmentcomponent"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent'">
							<b>UndefinedDataElementComponent</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.Component' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.component">
		<table>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@classcontrol != ''">
				<tr>
					<td class="row_cell">ClassControl</td>
					<td class="row_cell">
						<xsl:value-of select="@classcontrol"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:component_presencecheck"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_dbe"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_se"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.DataElementComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.dataelementcomponent">
		<table>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@classcontrol != ''">
				<tr>
					<td class="row_cell">ClassControl</td>
					<td class="row_cell">
						<xsl:value-of select="@classcontrol"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:dataelementcomponent_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:dataelementcomponent_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:component_presencecheck"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_dbe"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_se"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.Filler' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.filler">
		<table>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@format != ''">
				<tr>
					<td class="row_cell">Format</td>
					<td class="row_cell">
						<xsl:value-of select="@format"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@usage != ''">
				<tr>
					<td class="row_cell">Usage</td>
					<td class="row_cell">
						<xsl:value-of select="@usage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:filler_presencecheck"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.GroupComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.groupcomponent">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@classcontrol != ''">
				<tr>
					<td class="row_cell">ClassControl</td>
					<td class="row_cell">
						<xsl:value-of select="@classcontrol"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:component_presencecheck"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_dbe"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_se"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:groupcomponent_compositiongroup"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.LVDataElementComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvdataelementcomponent">
		<table>
			<xsl:if test="@datatype != ''">
				<tr>
					<td class="row_cell">DataType</td>
					<td class="row_cell">
						<xsl:value-of select="@datatype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presence != ''">
				<tr>
					<td class="row_cell">Presence</td>
					<td class="row_cell">
						<xsl:value-of select="@presence"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:lvdataelementcomponent_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:lvdataelementcomponent_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:logicalviewcomponent_subschemaassignment"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.LVGroupComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvgroupcomponent">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@datatype != ''">
				<tr>
					<td class="row_cell">DataType</td>
					<td class="row_cell">
						<xsl:value-of select="@datatype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presence != ''">
				<tr>
					<td class="row_cell">Presence</td>
					<td class="row_cell">
						<xsl:value-of select="@presence"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:logicalviewcomponent_subschemaassignment"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:lvgroupcomponent_compositiongroup"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.LVSegmentComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.lvsegmentcomponent">
		<table>
			<xsl:if test="@datatype != ''">
				<tr>
					<td class="row_cell">DataType</td>
					<td class="row_cell">
						<xsl:value-of select="@datatype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@presence != ''">
				<tr>
					<td class="row_cell">Presence</td>
					<td class="row_cell">
						<xsl:value-of select="@presence"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:lvsegmentcomponent_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:lvsegmentcomponent_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:logicalviewcomponent_subschemaassignment"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.LevelAddressLength' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.leveladdresslength">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@level != ''">
				<tr>
					<td class="row_cell">Level</td>
					<td class="row_cell">
						<xsl:value-of select="@level"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occursdisplay != ''">
				<tr>
					<td class="row_cell">OccursDisplay</td>
					<td class="row_cell">
						<xsl:value-of select="@occursdisplay"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internalformat != ''">
				<tr>
					<td class="row_cell">InternalFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@internalformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@usage != ''">
				<tr>
					<td class="row_cell">Usage</td>
					<td class="row_cell">
						<xsl:value-of select="@usage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internallength != ''">
				<tr>
					<td class="row_cell">InternalLength</td>
					<td class="row_cell">
						<xsl:value-of select="@internallength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internaladdress != ''">
				<tr>
					<td class="row_cell">InternalAddress</td>
					<td class="row_cell">
						<xsl:value-of select="@internaladdress"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputformat != ''">
				<tr>
					<td class="row_cell">InputFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@inputformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputlength != ''">
				<tr>
					<td class="row_cell">InputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@inputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inputaddress != ''">
				<tr>
					<td class="row_cell">InputAddress</td>
					<td class="row_cell">
						<xsl:value-of select="@inputaddress"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@rellabel != ''">
				<tr>
					<td class="row_cell">RelLabel</td>
					<td class="row_cell">
						<xsl:value-of select="@rellabel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@outputformat != ''">
				<tr>
					<td class="row_cell">OutputFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@outputformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@outputaddress != ''">
				<tr>
					<td class="row_cell">OutputAddress</td>
					<td class="row_cell">
						<xsl:value-of select="@outputaddress"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@outputlength != ''">
				<tr>
					<td class="row_cell">OutputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@outputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.MoreControls' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.morecontrols">
		<table>
			<xsl:if test="@operator != ''">
				<tr>
					<td class="row_cell">Operator</td>
					<td class="row_cell">
						<xsl:value-of select="@operator"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@negation != ''">
				<tr>
					<td class="row_cell">Negation</td>
					<td class="row_cell">
						<xsl:value-of select="@negation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controltype != ''">
				<tr>
					<td class="row_cell">ControlType</td>
					<td class="row_cell">
						<xsl:value-of select="@controltype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controlvalue != ''">
				<tr>
					<td class="row_cell">ControlValue</td>
					<td class="row_cell">
						<xsl:value-of select="@controlvalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@updatetarget != ''">
				<tr>
					<td class="row_cell">UpdateTarget</td>
					<td class="row_cell">
						<xsl:value-of select="@updatetarget"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@transferdirection != ''">
				<tr>
					<td class="row_cell">TransferDirection</td>
					<td class="row_cell">
						<xsl:value-of select="@transferdirection"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.PresenceCheck' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.presencecheck">
		<table>
			<xsl:if test="@increation != ''">
				<tr>
					<td class="row_cell">InCreation</td>
					<td class="row_cell">
						<xsl:value-of select="@increation"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@inmodification != ''">
				<tr>
					<td class="row_cell">InModification</td>
					<td class="row_cell">
						<xsl:value-of select="@inmodification"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@indeletion != ''">
				<tr>
					<td class="row_cell">InDeletion</td>
					<td class="row_cell">
						<xsl:value-of select="@indeletion"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@intype4 != ''">
				<tr>
					<td class="row_cell">InType4</td>
					<td class="row_cell">
						<xsl:value-of select="@intype4"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@intype5 != ''">
				<tr>
					<td class="row_cell">InType5</td>
					<td class="row_cell">
						<xsl:value-of select="@intype5"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@intype6 != ''">
				<tr>
					<td class="row_cell">InType6</td>
					<td class="row_cell">
						<xsl:value-of select="@intype6"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.RedefinesGroup' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.redefinesgroup">

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:redefinesgroup_setofredefines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.SQLComplement' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.sqlcomplement">
		<table>
			<xsl:if test="rpp:sqlcomplement_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:sqlcomplement_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:sqlcomplement_dataelementcolumn/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElementColumn</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:sqlcomplement_dataelementcolumn/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:sqlcomplement_undefineddataelementcolumn"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.SegmentComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.segmentcomponent">
		<table>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@classcontrol != ''">
				<tr>
					<td class="row_cell">ClassControl</td>
					<td class="row_cell">
						<xsl:value-of select="@classcontrol"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:segmentcomponent_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:segmentcomponent_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:component_presencecheck"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_dbe"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_se"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.SocrateElement' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.socrateelement">
		<table>
			<xsl:if test="@characteristictype != ''">
				<tr>
					<td class="row_cell">CharacteristicType</td>
					<td class="row_cell">
						<xsl:value-of select="@characteristictype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub0schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub0SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub0schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub1schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub1SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub1schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub2schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub2SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub2schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub3schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub3SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub3schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub4schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub4SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub4schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub5schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub5SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub5schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub6schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub6SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub6schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub7schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub7SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub7schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub8schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub8SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub8schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sub9schemaautorization != ''">
				<tr>
					<td class="row_cell">Sub9SchemaAutorization</td>
					<td class="row_cell">
						<xsl:value-of select="@sub9schemaautorization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@referencedcharacteristic != ''">
				<tr>
					<td class="row_cell">ReferencedCharacteristic</td>
					<td class="row_cell">
						<xsl:value-of select="@referencedcharacteristic"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.Statistics' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.statistics">
		<table>
			<xsl:if test="@nbdataelements != ''">
				<tr>
					<td class="row_cell">NbDataElements</td>
					<td class="row_cell">
						<xsl:value-of select="@nbdataelements"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nbelementaryfields != ''">
				<tr>
					<td class="row_cell">NbElementaryFields</td>
					<td class="row_cell">
						<xsl:value-of select="@nbelementaryfields"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@totalinputlength != ''">
				<tr>
					<td class="row_cell">TotalInputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@totalinputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@totalinternallength != ''">
				<tr>
					<td class="row_cell">TotalInternalLength</td>
					<td class="row_cell">
						<xsl:value-of select="@totalinternallength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@totaloutputlength != ''">
				<tr>
					<td class="row_cell">TotalOutputLength</td>
					<td class="row_cell">
						<xsl:value-of select="@totaloutputlength"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@nbsegmentcalls != ''">
				<tr>
					<td class="row_cell">NbSegmentCalls</td>
					<td class="row_cell">
						<xsl:value-of select="@nbsegmentcalls"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.SubSchemaAssignment' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.subschemaassignment">
		<table>
			<xsl:if test="@subschema1 != ''">
				<tr>
					<td class="row_cell">SubSchema1</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema1"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema2 != ''">
				<tr>
					<td class="row_cell">SubSchema2</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema2"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema3 != ''">
				<tr>
					<td class="row_cell">SubSchema3</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema3"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema4 != ''">
				<tr>
					<td class="row_cell">SubSchema4</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema4"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema5 != ''">
				<tr>
					<td class="row_cell">SubSchema5</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema5"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema6 != ''">
				<tr>
					<td class="row_cell">SubSchema6</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema6"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema7 != ''">
				<tr>
					<td class="row_cell">SubSchema7</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema7"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema8 != ''">
				<tr>
					<td class="row_cell">SubSchema8</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema8"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema9 != ''">
				<tr>
					<td class="row_cell">SubSchema9</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema9"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema10 != ''">
				<tr>
					<td class="row_cell">SubSchema10</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema10"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.segment.UndefinedDataElementComponent' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.segment.undefineddataelementcomponent">
		<table>
			<xsl:if test="@name != ''">
				<tr>
					<td class="row_cell">Name</td>
					<td class="row_cell">
						<xsl:value-of select="@name"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@label != ''">
				<tr>
					<td class="row_cell">Label</td>
					<td class="row_cell">
						<xsl:value-of select="@label"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internalusage != ''">
				<tr>
					<td class="row_cell">InternalUsage</td>
					<td class="row_cell">
						<xsl:value-of select="@internalusage"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@internalformat != ''">
				<tr>
					<td class="row_cell">InternalFormat</td>
					<td class="row_cell">
						<xsl:value-of select="@internalformat"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@sortkey != ''">
				<tr>
					<td class="row_cell">SortKey</td>
					<td class="row_cell">
						<xsl:value-of select="@sortkey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@classcontrol != ''">
				<tr>
					<td class="row_cell">ClassControl</td>
					<td class="row_cell">
						<xsl:value-of select="@classcontrol"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@occurs != ''">
				<tr>
					<td class="row_cell">Occurs</td>
					<td class="row_cell">
						<xsl:value-of select="@occurs"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--unary composition -->
		<xsl:apply-templates select="rpp:component_presencecheck"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_dbe"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:component_se"></xsl:apply-templates>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:abstractceline_morecontrols"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gclines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gelines"></xsl:apply-templates>
		<xsl:apply-templates select="rpp:abstractceline_gglines"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>