<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="RadicalElement.xsl"></xsl:import>

	<!-- Template for the relation: 'GCLines' -->
	<xsl:template match="rpp:abstractradicalelement_gclines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GCLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Data' -->
	<xsl:template match="rpp:inputaidgline_data">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Data</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:value-of select="."></xsl:value-of>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.GLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:line_linkedentity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LinkedEntity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:line_linkedentity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.InputAidGLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline">
		<table>
			<xsl:if test="@linetype != ''">
				<tr>
					<td class="row_cell">LineType</td>
					<td class="row_cell">
						<xsl:value-of select="@linetype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@description != ''">
				<tr>
					<td class="row_cell">Description</td>
					<td class="row_cell">
						<xsl:value-of select="@description"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:inputaidgline_inputaid/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>InputAid</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:inputaidgline_inputaid/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:line_linkedentity/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LinkedEntity</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:line_linkedentity/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:inputaidgline_data"></xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>