<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the relation: 'CPLines' -->
	<xsl:template match="rpp:abstractdialogfolder_cplines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CPLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CPLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GOLines' -->
	<xsl:template match="rpp:abstractdialogfolder_golines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GOLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Parameters' -->
	<xsl:template match="rpp:cpline_parameters">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Parameters</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>MacroParameters</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.CPLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline">
		<table>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:cpline_macro/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Macro</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:cpline_macro/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:cpline_parameters"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.MacroParameters' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters">
		<table>
			<xsl:if test="@id != ''">
				<tr>
					<td class="row_cell">Id</td>
					<td class="row_cell">
						<xsl:value-of select="@id"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:macroparameters_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>