<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:rpp="https://com.ibm.pdp.pac.publishing" version="1.0" exclude-result-prefixes="xsi rpp">

	<xsl:import href="AbstractRadicalElement.xsl"></xsl:import>

	<!-- Template for the relation: 'CPLines' -->
	<xsl:template match="rpp:abstractdialog_cplines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CPLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>CPLine</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'CSLines' -->
	<xsl:template match="rpp:abstractdialog_cslines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>CSLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.DataElementCallCSLine'">
							<b>DataElementCallCSLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.dataelementcallcsline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.LogicalViewCallCSLine'">
							<b>LogicalViewCallCSLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.logicalviewcallcsline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.SegmentCallCSLine'">
							<b>SegmentCallCSLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.segmentcallcsline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.dialog.ServerCallCSLine'">
							<b>ServerCallCSLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.servercallcsline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GELines' -->
	<xsl:template match="rpp:abstractdialog_gelines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GELines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GGLines' -->
	<xsl:template match="rpp:abstractdialog_gglines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GGLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'GOLines' -->
	<xsl:template match="rpp:abstractdialog_golines">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>GOLines</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<xsl:choose>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.GLine'">
							<b>GLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.gline"></xsl:call-template>
						</xsl:when>
						<xsl:when test="@xsi:type='com.ibm.pdp.maf.rpp.pac.common.InputAidGLine'">
							<b>InputAidGLine</b>
							<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.inputaidgline"></xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the relation: 'Parameters' -->
	<xsl:template match="rpp:cpline_parameters">
		<xsl:variable name="position" select="position()"></xsl:variable>
		<xsl:if test="$position=1">
			<h3>Parameters</h3>
		</xsl:if>
		<ul>
			<li>
				<p>
					<b>MacroParameters</b>
					<xsl:call-template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters"></xsl:call-template>
				</p>
			</li>
		</ul>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.CPLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.cpline">
		<table>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@comment != ''">
				<tr>
					<td class="row_cell">Comment</td>
					<td class="row_cell">
						<xsl:value-of select="@comment"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:cpline_macro/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Macro</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:cpline_macro/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>

		<!--multiple composition -->
		<xsl:apply-templates select="rpp:cpline_parameters"></xsl:apply-templates>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.DataElementCallCSLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.dataelementcallcsline">
		<table>
			<xsl:if test="@categorynature != ''">
				<tr>
					<td class="row_cell">CategoryNature</td>
					<td class="row_cell">
						<xsl:value-of select="@categorynature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@segmentcode != ''">
				<tr>
					<td class="row_cell">SegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@segmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationlimit != ''">
				<tr>
					<td class="row_cell">GenerationLimit</td>
					<td class="row_cell">
						<xsl:value-of select="@generationlimit"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@previoussegmentcode != ''">
				<tr>
					<td class="row_cell">PreviousSegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@previoussegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeysource != ''">
				<tr>
					<td class="row_cell">AccessKeySource</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeysource"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskey != ''">
				<tr>
					<td class="row_cell">AccessKey</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controlbreak != ''">
				<tr>
					<td class="row_cell">ControlBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@controlbreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@descriptiontype != ''">
				<tr>
					<td class="row_cell">DescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@descriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema != ''">
				<tr>
					<td class="row_cell">SubSchema</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlevel != ''">
				<tr>
					<td class="row_cell">GeneratedLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtypevalue != ''">
				<tr>
					<td class="row_cell">RecordTypeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtypevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayuse != ''">
				<tr>
					<td class="row_cell">DisplayUse</td>
					<td class="row_cell">
						<xsl:value-of select="@displayuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@receptionuse != ''">
				<tr>
					<td class="row_cell">ReceptionUse</td>
					<td class="row_cell">
						<xsl:value-of select="@receptionuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenorganization != ''">
				<tr>
					<td class="row_cell">ScreenOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@screenorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@clientorganization != ''">
				<tr>
					<td class="row_cell">ClientOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@clientorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serverorganization != ''">
				<tr>
					<td class="row_cell">ServerOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@serverorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:abstractcsline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractcsline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.LogicalViewCallCSLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.logicalviewcallcsline">
		<table>
			<xsl:if test="@categorynature != ''">
				<tr>
					<td class="row_cell">CategoryNature</td>
					<td class="row_cell">
						<xsl:value-of select="@categorynature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@segmentcode != ''">
				<tr>
					<td class="row_cell">SegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@segmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationlimit != ''">
				<tr>
					<td class="row_cell">GenerationLimit</td>
					<td class="row_cell">
						<xsl:value-of select="@generationlimit"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@previoussegmentcode != ''">
				<tr>
					<td class="row_cell">PreviousSegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@previoussegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeysource != ''">
				<tr>
					<td class="row_cell">AccessKeySource</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeysource"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskey != ''">
				<tr>
					<td class="row_cell">AccessKey</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controlbreak != ''">
				<tr>
					<td class="row_cell">ControlBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@controlbreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@descriptiontype != ''">
				<tr>
					<td class="row_cell">DescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@descriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema != ''">
				<tr>
					<td class="row_cell">SubSchema</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlevel != ''">
				<tr>
					<td class="row_cell">GeneratedLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtypevalue != ''">
				<tr>
					<td class="row_cell">RecordTypeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtypevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayuse != ''">
				<tr>
					<td class="row_cell">DisplayUse</td>
					<td class="row_cell">
						<xsl:value-of select="@displayuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@receptionuse != ''">
				<tr>
					<td class="row_cell">ReceptionUse</td>
					<td class="row_cell">
						<xsl:value-of select="@receptionuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenorganization != ''">
				<tr>
					<td class="row_cell">ScreenOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@screenorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@clientorganization != ''">
				<tr>
					<td class="row_cell">ClientOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@clientorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serverorganization != ''">
				<tr>
					<td class="row_cell">ServerOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@serverorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:logicalviewcallcsline_logicalview/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>LogicalView</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:logicalviewcallcsline_logicalview/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractcsline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractcsline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.program.MacroParameters' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.program.macroparameters">
		<table>
			<xsl:if test="@id != ''">
				<tr>
					<td class="row_cell">Id</td>
					<td class="row_cell">
						<xsl:value-of select="@id"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@value != ''">
				<tr>
					<td class="row_cell">Value</td>
					<td class="row_cell">
						<xsl:value-of select="@value"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:macroparameters_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_datastructure/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataStructure</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_datastructure/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:macroparameters_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:macroparameters_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.SegmentCallCSLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.segmentcallcsline">
		<table>
			<xsl:if test="@categorynature != ''">
				<tr>
					<td class="row_cell">CategoryNature</td>
					<td class="row_cell">
						<xsl:value-of select="@categorynature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@segmentcode != ''">
				<tr>
					<td class="row_cell">SegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@segmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationlimit != ''">
				<tr>
					<td class="row_cell">GenerationLimit</td>
					<td class="row_cell">
						<xsl:value-of select="@generationlimit"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@previoussegmentcode != ''">
				<tr>
					<td class="row_cell">PreviousSegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@previoussegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeysource != ''">
				<tr>
					<td class="row_cell">AccessKeySource</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeysource"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskey != ''">
				<tr>
					<td class="row_cell">AccessKey</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controlbreak != ''">
				<tr>
					<td class="row_cell">ControlBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@controlbreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@descriptiontype != ''">
				<tr>
					<td class="row_cell">DescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@descriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema != ''">
				<tr>
					<td class="row_cell">SubSchema</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlevel != ''">
				<tr>
					<td class="row_cell">GeneratedLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtypevalue != ''">
				<tr>
					<td class="row_cell">RecordTypeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtypevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayuse != ''">
				<tr>
					<td class="row_cell">DisplayUse</td>
					<td class="row_cell">
						<xsl:value-of select="@displayuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@receptionuse != ''">
				<tr>
					<td class="row_cell">ReceptionUse</td>
					<td class="row_cell">
						<xsl:value-of select="@receptionuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenorganization != ''">
				<tr>
					<td class="row_cell">ScreenOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@screenorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@clientorganization != ''">
				<tr>
					<td class="row_cell">ClientOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@clientorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serverorganization != ''">
				<tr>
					<td class="row_cell">ServerOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@serverorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:segmentcallcsline_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:segmentcallcsline_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:segmentcallcsline_blockbase/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>BlockBase</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:segmentcallcsline_blockbase/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractcsline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractcsline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<!-- Template for the class: 'com.ibm.pdp.maf.rpp.pac.common.dialog.ServerCallCSLine' -->
	<xsl:template name="rpp:class_com.ibm.pdp.maf.rpp.pac.common.dialog.servercallcsline">
		<table>
			<xsl:if test="@categorynature != ''">
				<tr>
					<td class="row_cell">CategoryNature</td>
					<td class="row_cell">
						<xsl:value-of select="@categorynature"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@segmentcode != ''">
				<tr>
					<td class="row_cell">SegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@segmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@linenumber != ''">
				<tr>
					<td class="row_cell">LineNumber</td>
					<td class="row_cell">
						<xsl:value-of select="@linenumber"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generationlimit != ''">
				<tr>
					<td class="row_cell">GenerationLimit</td>
					<td class="row_cell">
						<xsl:value-of select="@generationlimit"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@previoussegmentcode != ''">
				<tr>
					<td class="row_cell">PreviousSegmentCode</td>
					<td class="row_cell">
						<xsl:value-of select="@previoussegmentcode"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskeysource != ''">
				<tr>
					<td class="row_cell">AccessKeySource</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskeysource"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@accesskey != ''">
				<tr>
					<td class="row_cell">AccessKey</td>
					<td class="row_cell">
						<xsl:value-of select="@accesskey"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@controlbreak != ''">
				<tr>
					<td class="row_cell">ControlBreak</td>
					<td class="row_cell">
						<xsl:value-of select="@controlbreak"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@descriptiontype != ''">
				<tr>
					<td class="row_cell">DescriptionType</td>
					<td class="row_cell">
						<xsl:value-of select="@descriptiontype"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@externalname != ''">
				<tr>
					<td class="row_cell">ExternalName</td>
					<td class="row_cell">
						<xsl:value-of select="@externalname"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@subschema != ''">
				<tr>
					<td class="row_cell">SubSchema</td>
					<td class="row_cell">
						<xsl:value-of select="@subschema"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@generatedlevel != ''">
				<tr>
					<td class="row_cell">GeneratedLevel</td>
					<td class="row_cell">
						<xsl:value-of select="@generatedlevel"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@recordtypevalue != ''">
				<tr>
					<td class="row_cell">RecordTypeValue</td>
					<td class="row_cell">
						<xsl:value-of select="@recordtypevalue"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@displayuse != ''">
				<tr>
					<td class="row_cell">DisplayUse</td>
					<td class="row_cell">
						<xsl:value-of select="@displayuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@receptionuse != ''">
				<tr>
					<td class="row_cell">ReceptionUse</td>
					<td class="row_cell">
						<xsl:value-of select="@receptionuse"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@screenorganization != ''">
				<tr>
					<td class="row_cell">ScreenOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@screenorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@clientorganization != ''">
				<tr>
					<td class="row_cell">ClientOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@clientorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="@serverorganization != ''">
				<tr>
					<td class="row_cell">ServerOrganization</td>
					<td class="row_cell">
						<xsl:value-of select="@serverorganization"></xsl:value-of>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table>
			<xsl:if test="rpp:servercallcsline_segment/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Segment</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:servercallcsline_segment/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:servercallcsline_server/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>Server</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:servercallcsline_server/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="rpp:abstractcsline_dataelement/@idref != ''">
				<tr>
					<td class="row_cell">
						<b>DataElement</b>
					</td>
					<td class="row_cell">
						<xsl:call-template name="rpp:artifact.link">
							<xsl:with-param name="idref" select="rpp:abstractcsline_dataelement/@idref"></xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>