/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.wizard.page;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.wizard.page.PTWizardPage;
import com.ibm.pdp.pac.publishing.plugin.IPacVolumePreferences;
import com.ibm.pdp.pac.publishing.provider.PacResourceContentProvider;
import com.ibm.pdp.pac.publishing.provider.PacResourceLabelProvider;
import com.ibm.pdp.pac.volume.pattern.PacVolumePattern;
import com.ibm.pdp.pac.volume.wizard.PacVolumeWizardLabel;
import com.ibm.pdp.pdppath.nature.PDPPathNature;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class PacVolumeOutputWizardPage
extends PTWizardPage
implements IPacVolumePreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _XML_EXTENSION = "*.xml";
    private static final String _HTML_EXTENSION = "*.html";
    private static final String _ALL_EXTENSION = "*.*";
    private Button _rdbXML;
    private Button _rdbHTML;
    private Button _rdbFileLocal;
    private Text _txtFileLocalFolder;
    private TreeViewer _trvViewerFile;
    private Text _txtFileLocalName;
    private Button _rdbFileExternal;
    private Text _txtFileExternalName;
    private Button _pbFileBrowse;
    private PacVolumePattern _pattern;

    public PacVolumeOutputWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_OUTPUT_PAGE_TITLE));
        this.setDescription(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_OUTPUT_PAGE_DESC));
        this._prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.pac.publishing");
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.Volume_Gen";
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        GridData gridData = new GridData(4, 1, true, false);
        composite.setLayoutData((Object)gridData);
        this.setHelp(composite);
        this.createFormatGroup(composite);
        this.createFileGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.setControl((Control)composite);
    }

    private void createFormatGroup(Composite parent) {
        String grpLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_FORMAT_GROUP);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)grpLabel);
        String rdbLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._OUTPUT_XML);
        this._rdbXML = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)true);
        this._rdbXML.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbXML);
        rdbLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._OUTPUT_HTML);
        this._rdbHTML = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false);
        this._rdbHTML.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.addSelectionListener(this._rdbHTML);
    }

    private void createFileGroup(Composite parent) {
        String grpLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_OUTPUT_GROUP);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (String)grpLabel);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        String rdbLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._LOCAL_OUTPUT);
        this._rdbFileLocal = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)true, (int)2);
        this.addSelectionListener(this._rdbFileLocal);
        this._txtFileLocalFolder = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false, (int)2);
        this.addModifyListener(this._txtFileLocalFolder);
        this._trvViewerFile = PTWidgetTool.createTreeViewer((Composite)group, (boolean)true);
        this._trvViewerFile.setUseHashlookup(true);
        this._trvViewerFile.setContentProvider((IContentProvider)new PacResourceContentProvider());
        this._trvViewerFile.setLabelProvider((IBaseLabelProvider)new PacResourceLabelProvider());
        this._trvViewerFile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    IResource resource = (IResource)selection.getFirstElement();
                    String resourceName = resource.getFullPath().toString().substring(1);
                    PacVolumeOutputWizardPage.this._txtFileLocalFolder.setText(resourceName);
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        this._trvViewerFile.getControl().setLayoutData((Object)gridData);
        PTWidgetTool.createLabel((Composite)group, (String)PacVolumeWizardLabel.getString(PacVolumeWizardLabel._OUTPUT_FILE));
        this._txtFileLocalName = PTWidgetTool.createTextField((Composite)group, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtFileLocalName);
        rdbLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._EXTERNAL_FILE_OUTPUT);
        this._rdbFileExternal = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false, (int)2);
        this.addSelectionListener(this._rdbFileExternal);
        Composite externalPane = PTWidgetTool.createComposite((Composite)group, (int)2, (int)2, (boolean)false);
        this._txtFileExternalName = PTWidgetTool.createTextField((Composite)externalPane, (boolean)false, (boolean)false);
        this.addModifyListener(this._txtFileExternalName);
        String pbLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._BROWSE);
        this._pbFileBrowse = PTWidgetTool.createPushButton((Composite)externalPane, (String)pbLabel, (boolean)true);
        this.addSelectionListener(this._pbFileBrowse);
    }

    protected void handleModifyText(ModifyEvent e) {
        if (e.widget == this._txtFileLocalFolder || e.widget == this._txtFileLocalName || e.widget == this._txtFileExternalName) {
            if (e.widget == this._txtFileLocalFolder) {
                this._pattern._fileLocalFolder = this._txtFileLocalFolder.getText().trim();
            } else if (e.widget == this._txtFileLocalName) {
                this._pattern._fileLocalName = this._txtFileLocalName.getText().trim();
            } else if (e.widget == this._txtFileExternalName) {
                this._pattern._fileExternalName = this._txtFileExternalName.getText().trim();
            }
            this.setPageComplete(this.isPageComplete());
        }
    }

    protected void handleButtonSelected(SelectionEvent e) {
        if (e.widget == this._rdbXML || e.widget == this._rdbHTML) {
            if (this._rdbXML.getSelection()) {
                this._pattern._outputFormat = PacVolumePattern.OutputFormat._XML;
            } else if (this._rdbHTML.getSelection()) {
                this._pattern._outputFormat = PacVolumePattern.OutputFormat._HTML;
            }
            this.refresh();
        } else if (e.widget == this._rdbFileLocal || e.widget == this._rdbFileExternal) {
            this._pattern._outputTarget = this._rdbFileLocal.getSelection() ? PacVolumePattern.OutputTarget._LOCAL : PacVolumePattern.OutputTarget._EXTERNAL;
            this.refresh();
        } else if (e.widget == this._pbFileBrowse) {
            String extension = _ALL_EXTENSION;
            if (this._rdbXML.getSelection()) {
                extension = _XML_EXTENSION;
            } else if (this._rdbHTML.getSelection()) {
                extension = _HTML_EXTENSION;
            }
            FileDialog dialog = new FileDialog(this.getShell(), 40960);
            dialog.setFilterExtensions(new String[]{extension});
            String fileName = dialog.open();
            if (fileName != null && fileName.length() > 0) {
                if (!fileName.endsWith(extension.substring(1))) {
                    fileName = String.valueOf(fileName) + extension.substring(1);
                }
                this._txtFileExternalName.setText(fileName);
            }
        }
    }

    public boolean isPageComplete() {
        String file;
        String message = "";
        if (this._rdbFileLocal.getSelection()) {
            String file2;
            String folder = this._txtFileLocalFolder.getText();
            if (folder.length() > 0) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = workspaceRoot.findMember(folder);
                if (resource == null) {
                    message = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._OUTPUT_CONTAINER_NOT_EXIST);
                }
            } else {
                message = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._NO_OUTPUT_FOLDER);
            }
            if (message.length() == 0 && (file2 = this._txtFileLocalName.getText()).length() == 0) {
                message = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._NO_OUTPUT_FILE);
            }
        } else if (this._rdbFileExternal.getSelection() && (file = this._txtFileExternalName.getText()).length() == 0) {
            message = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._NO_OUTPUT_FILE);
        }
        if (message.length() > 0) {
            this.setErrorMessage(message);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setupData() {
        this._pattern = new PacVolumePattern();
        this._pattern._outputFormat = PacVolumePattern.OutputFormat.valueOf(this._prefs.get("_PREF_VOLUME_FORMAT", PacVolumePattern.OutputFormat._XML.toString()));
        this._pattern._outputTarget = PacVolumePattern.OutputTarget.valueOf(this._prefs.get("_PREF_VOLUME_TARGET", PacVolumePattern.OutputTarget._EXTERNAL.toString()));
        this._pattern._fileLocalFolder = this._prefs.get("_PREF_VOLUME_FILE_LOCAL_FOLDER", "");
        this._pattern._fileLocalName = this._prefs.get("_PREF_VOLUME_FILE_LOCAL_NAME", "");
        this._pattern._fileExternalName = this._prefs.get("_PREF_VOLUME_FILE_EXTERNAL_NAME", "");
        this._rdbXML.setSelection(this._pattern._outputFormat == PacVolumePattern.OutputFormat._XML);
        this._rdbHTML.setSelection(this._pattern._outputFormat == PacVolumePattern.OutputFormat._HTML);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (PDPPathNature.getNature((String)project.getName()) == null) {
                projects.add(project);
            }
            ++n2;
        }
        this._rdbFileLocal.setSelection(this._pattern._outputTarget == PacVolumePattern.OutputTarget._LOCAL);
        this._rdbFileExternal.setSelection(this._pattern._outputTarget == PacVolumePattern.OutputTarget._EXTERNAL);
        this._txtFileLocalFolder.setText(this._pattern._fileLocalFolder);
        this._txtFileLocalName.setText(this._pattern._fileLocalName);
        this._txtFileExternalName.setText(this._pattern._fileExternalName);
        this._trvViewerFile.setInput(projects);
        IResource resource = workspaceRoot.findMember((IPath)new Path(this._txtFileLocalFolder.getText()));
        if (resource != null) {
            this._trvViewerFile.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        this.refresh();
    }

    public PacVolumePattern getPattern() {
        return this._pattern;
    }

    public void refresh() {
        this._txtFileLocalFolder.setEnabled(this._rdbFileLocal.getSelection());
        this._trvViewerFile.getControl().setEnabled(this._rdbFileLocal.getSelection());
        this._txtFileLocalName.setEnabled(this._rdbFileLocal.getSelection());
        this._txtFileExternalName.setEnabled(this._rdbFileExternal.getSelection());
        this._pbFileBrowse.setEnabled(this._rdbFileExternal.getSelection());
        this.setPageComplete(this.isPageComplete());
    }

    public void updatePreferences() {
        this._prefs.put("_PREF_VOLUME_FORMAT", this._pattern._outputFormat.toString());
        this._prefs.put("_PREF_VOLUME_TARGET", this._pattern._outputTarget.toString());
        this._prefs.put("_PREF_VOLUME_FILE_LOCAL_FOLDER", this._pattern._fileLocalFolder);
        this._prefs.put("_PREF_VOLUME_FILE_LOCAL_NAME", this._pattern._fileLocalName);
        this._prefs.put("_PREF_VOLUME_FILE_EXTERNAL_NAME", this._pattern._fileExternalName);
    }
}

