/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.volume.wizard;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.pac.publishing.serializer.IPacPublishingTags;
import com.ibm.pdp.pac.volume.pattern.PacVolumePattern;
import com.ibm.pdp.pac.volume.serializer.PacVolumeSerializer;
import com.ibm.pdp.pac.volume.wizard.PacVolumeWizardLabel;
import com.ibm.pdp.pac.volume.wizard.page.PacVolumeOutputWizardPage;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public class PacVolumeGenerationWizard
extends Wizard
implements IPacPublishingTags {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacVolumeOutputWizardPage _outputPage;
    PacVolume _volume;

    public PacVolumeGenerationWizard(PacVolume volume) {
        this.setWindowTitle(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_WIZARD_TITLE));
        this.setNeedsProgressMonitor(true);
        this._volume = volume;
    }

    public void addPages() {
        this._outputPage = new PacVolumeOutputWizardPage("outputPage_ID");
        this.addPage((IWizardPage)this._outputPage);
        super.addPages();
    }

    public boolean performFinish() {
        final PacVolumePattern pattern = this._outputPage.getPattern();
        Job volumeJob = new Job(PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_JOB)){

            protected IStatus run(IProgressMonitor monitor) {
                final List statusList = PacVolumeGenerationWizard.this.generateVolume(pattern, monitor);
                if (!monitor.isCanceled()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (statusList.size() > 0) {
                                String dialogLabel = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_ERROR_LABEL);
                                MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 4, dialogLabel, null);
                                int i = 0;
                                while (i < statusList.size()) {
                                    IStatus status = (IStatus)statusList.get(i);
                                    multiStatus.add(status);
                                    ++i;
                                }
                                String dialogTitle = PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_ERROR_TITLE);
                                PTMessageManager.handleErrors((String)dialogTitle, (MultiStatus)multiStatus);
                            } else {
                                PTMessageManager.handleInformation((String)PacVolumeWizardLabel.getString(PacVolumeWizardLabel._VOLUME_GENERATION_ENDED));
                            }
                        }
                    });
                }
                monitor.done();
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        volumeJob.setPriority(50);
        volumeJob.setUser(true);
        volumeJob.schedule();
        this.updatePreferences();
        return true;
    }

    private List<IStatus> generateVolume(PacVolumePattern pattern, IProgressMonitor monitor) {
        List<IStatus> statusList = Collections.emptyList();
        PacVolumeSerializer volumeSerializer = new PacVolumeSerializer(pattern);
        statusList = volumeSerializer.serialize(this._volume, monitor);
        return statusList;
    }

    private void updatePreferences() {
        this._outputPage.updatePreferences();
    }

    public boolean canFinish() {
        return this._outputPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

